package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.VpcEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateVpcEndpointRequest(
    vpcEndpointId: VpcEndpointId,
    vpcOptions: zio.aws.elasticsearch.model.VPCOptions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointRequest = {
    import UpdateVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointRequest
      .builder()
      .vpcEndpointId(VpcEndpointId.unwrap(vpcEndpointId): java.lang.String)
      .vpcOptions(vpcOptions.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.UpdateVpcEndpointRequest.ReadOnly =
    zio.aws.elasticsearch.model.UpdateVpcEndpointRequest.wrap(buildAwsValue())
}
object UpdateVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.UpdateVpcEndpointRequest =
      zio.aws.elasticsearch.model
        .UpdateVpcEndpointRequest(vpcEndpointId, vpcOptions.asEditable)
    def vpcEndpointId: VpcEndpointId
    def vpcOptions: zio.aws.elasticsearch.model.VPCOptions.ReadOnly
    def getVpcEndpointId: ZIO[Any, Nothing, VpcEndpointId] =
      ZIO.succeed(vpcEndpointId)
    def getVpcOptions
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.VPCOptions.ReadOnly] =
      ZIO.succeed(vpcOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointRequest
  ) extends zio.aws.elasticsearch.model.UpdateVpcEndpointRequest.ReadOnly {
    override val vpcEndpointId: VpcEndpointId =
      zio.aws.elasticsearch.model.primitives.VpcEndpointId(impl.vpcEndpointId())
    override val vpcOptions: zio.aws.elasticsearch.model.VPCOptions.ReadOnly =
      zio.aws.elasticsearch.model.VPCOptions.wrap(impl.vpcOptions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointRequest
  ): zio.aws.elasticsearch.model.UpdateVpcEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
