package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ElasticsearchDomainConfig(
    elasticsearchVersion: Optional[
      zio.aws.elasticsearch.model.ElasticsearchVersionStatus
    ] = Optional.Absent,
    elasticsearchClusterConfig: Optional[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus
    ] = Optional.Absent,
    ebsOptions: Optional[zio.aws.elasticsearch.model.EBSOptionsStatus] =
      Optional.Absent,
    accessPolicies: Optional[zio.aws.elasticsearch.model.AccessPoliciesStatus] =
      Optional.Absent,
    snapshotOptions: Optional[
      zio.aws.elasticsearch.model.SnapshotOptionsStatus
    ] = Optional.Absent,
    vpcOptions: Optional[zio.aws.elasticsearch.model.VPCDerivedInfoStatus] =
      Optional.Absent,
    cognitoOptions: Optional[zio.aws.elasticsearch.model.CognitoOptionsStatus] =
      Optional.Absent,
    encryptionAtRestOptions: Optional[
      zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus
    ] = Optional.Absent,
    nodeToNodeEncryptionOptions: Optional[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus
    ] = Optional.Absent,
    advancedOptions: Optional[
      zio.aws.elasticsearch.model.AdvancedOptionsStatus
    ] = Optional.Absent,
    logPublishingOptions: Optional[
      zio.aws.elasticsearch.model.LogPublishingOptionsStatus
    ] = Optional.Absent,
    domainEndpointOptions: Optional[
      zio.aws.elasticsearch.model.DomainEndpointOptionsStatus
    ] = Optional.Absent,
    advancedSecurityOptions: Optional[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus
    ] = Optional.Absent,
    autoTuneOptions: Optional[
      zio.aws.elasticsearch.model.AutoTuneOptionsStatus
    ] = Optional.Absent,
    changeProgressDetails: Optional[
      zio.aws.elasticsearch.model.ChangeProgressDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig = {
    import ElasticsearchDomainConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig
      .builder()
      .optionallyWith(elasticsearchVersion.map(value => value.buildAwsValue()))(
        _.elasticsearchVersion
      )
      .optionallyWith(
        elasticsearchClusterConfig.map(value => value.buildAwsValue())
      )(_.elasticsearchClusterConfig)
      .optionallyWith(ebsOptions.map(value => value.buildAwsValue()))(
        _.ebsOptions
      )
      .optionallyWith(accessPolicies.map(value => value.buildAwsValue()))(
        _.accessPolicies
      )
      .optionallyWith(snapshotOptions.map(value => value.buildAwsValue()))(
        _.snapshotOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(cognitoOptions.map(value => value.buildAwsValue()))(
        _.cognitoOptions
      )
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(advancedOptions.map(value => value.buildAwsValue()))(
        _.advancedOptions
      )
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .optionallyWith(autoTuneOptions.map(value => value.buildAwsValue()))(
        _.autoTuneOptions
      )
      .optionallyWith(
        changeProgressDetails.map(value => value.buildAwsValue())
      )(_.changeProgressDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly =
    zio.aws.elasticsearch.model.ElasticsearchDomainConfig.wrap(buildAwsValue())
}
object ElasticsearchDomainConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ElasticsearchDomainConfig =
      zio.aws.elasticsearch.model.ElasticsearchDomainConfig(
        elasticsearchVersion.map(value => value.asEditable),
        elasticsearchClusterConfig.map(value => value.asEditable),
        ebsOptions.map(value => value.asEditable),
        accessPolicies.map(value => value.asEditable),
        snapshotOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        cognitoOptions.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        advancedOptions.map(value => value.asEditable),
        logPublishingOptions.map(value => value.asEditable),
        domainEndpointOptions.map(value => value.asEditable),
        advancedSecurityOptions.map(value => value.asEditable),
        autoTuneOptions.map(value => value.asEditable),
        changeProgressDetails.map(value => value.asEditable)
      )
    def elasticsearchVersion: Optional[
      zio.aws.elasticsearch.model.ElasticsearchVersionStatus.ReadOnly
    ]
    def elasticsearchClusterConfig: Optional[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.ReadOnly
    ]
    def ebsOptions
        : Optional[zio.aws.elasticsearch.model.EBSOptionsStatus.ReadOnly]
    def accessPolicies
        : Optional[zio.aws.elasticsearch.model.AccessPoliciesStatus.ReadOnly]
    def snapshotOptions
        : Optional[zio.aws.elasticsearch.model.SnapshotOptionsStatus.ReadOnly]
    def vpcOptions
        : Optional[zio.aws.elasticsearch.model.VPCDerivedInfoStatus.ReadOnly]
    def cognitoOptions
        : Optional[zio.aws.elasticsearch.model.CognitoOptionsStatus.ReadOnly]
    def encryptionAtRestOptions: Optional[
      zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.ReadOnly
    ]
    def nodeToNodeEncryptionOptions: Optional[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly
    ]
    def advancedOptions
        : Optional[zio.aws.elasticsearch.model.AdvancedOptionsStatus.ReadOnly]
    def logPublishingOptions: Optional[
      zio.aws.elasticsearch.model.LogPublishingOptionsStatus.ReadOnly
    ]
    def domainEndpointOptions: Optional[
      zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.ReadOnly
    ]
    def advancedSecurityOptions: Optional[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.ReadOnly
    ]
    def autoTuneOptions
        : Optional[zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly]
    def changeProgressDetails
        : Optional[zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly]
    def getElasticsearchVersion: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ElasticsearchVersionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("elasticsearchVersion", elasticsearchVersion)
    def getElasticsearchClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchClusterConfig",
      elasticsearchClusterConfig
    )
    def getEbsOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.EBSOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("ebsOptions", ebsOptions)
    def getAccessPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AccessPoliciesStatus.ReadOnly
    ] = AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getSnapshotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SnapshotOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotOptions", snapshotOptions)
    def getVpcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.VPCDerivedInfoStatus.ReadOnly
    ] = AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getCognitoOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.CognitoOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoOptions", cognitoOptions)
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getAdvancedOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AdvancedOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getLogPublishingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.LogPublishingOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
    def getAutoTuneOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneOptions", autoTuneOptions)
    def getChangeProgressDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("changeProgressDetails", changeProgressDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig
  ) extends zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly {
    override val elasticsearchVersion: Optional[
      zio.aws.elasticsearch.model.ElasticsearchVersionStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticsearchVersion())
      .map(value =>
        zio.aws.elasticsearch.model.ElasticsearchVersionStatus.wrap(value)
      )
    override val elasticsearchClusterConfig: Optional[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticsearchClusterConfig())
      .map(value =>
        zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.wrap(value)
      )
    override val ebsOptions
        : Optional[zio.aws.elasticsearch.model.EBSOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsOptions())
        .map(value => zio.aws.elasticsearch.model.EBSOptionsStatus.wrap(value))
    override val accessPolicies
        : Optional[zio.aws.elasticsearch.model.AccessPoliciesStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPolicies())
        .map(value =>
          zio.aws.elasticsearch.model.AccessPoliciesStatus.wrap(value)
        )
    override val snapshotOptions
        : Optional[zio.aws.elasticsearch.model.SnapshotOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotOptions())
        .map(value =>
          zio.aws.elasticsearch.model.SnapshotOptionsStatus.wrap(value)
        )
    override val vpcOptions
        : Optional[zio.aws.elasticsearch.model.VPCDerivedInfoStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOptions())
        .map(value =>
          zio.aws.elasticsearch.model.VPCDerivedInfoStatus.wrap(value)
        )
    override val cognitoOptions
        : Optional[zio.aws.elasticsearch.model.CognitoOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoOptions())
        .map(value =>
          zio.aws.elasticsearch.model.CognitoOptionsStatus.wrap(value)
        )
    override val encryptionAtRestOptions: Optional[
      zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionAtRestOptions())
      .map(value =>
        zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.wrap(value)
      )
    override val nodeToNodeEncryptionOptions: Optional[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus
          .wrap(value)
      )
    override val advancedOptions
        : Optional[zio.aws.elasticsearch.model.AdvancedOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedOptions())
        .map(value =>
          zio.aws.elasticsearch.model.AdvancedOptionsStatus.wrap(value)
        )
    override val logPublishingOptions: Optional[
      zio.aws.elasticsearch.model.LogPublishingOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingOptions())
      .map(value =>
        zio.aws.elasticsearch.model.LogPublishingOptionsStatus.wrap(value)
      )
    override val domainEndpointOptions: Optional[
      zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainEndpointOptions())
      .map(value =>
        zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.wrap(value)
      )
    override val advancedSecurityOptions: Optional[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedSecurityOptions())
      .map(value =>
        zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.wrap(value)
      )
    override val autoTuneOptions
        : Optional[zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTuneOptions())
        .map(value =>
          zio.aws.elasticsearch.model.AutoTuneOptionsStatus.wrap(value)
        )
    override val changeProgressDetails
        : Optional[zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeProgressDetails())
        .map(value =>
          zio.aws.elasticsearch.model.ChangeProgressDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig
  ): zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly =
    new Wrapper(impl)
}
