package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.PackageID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePackageRequest(packageID: PackageID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest = {
    import DeletePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DeletePackageRequest.ReadOnly =
    zio.aws.elasticsearch.model.DeletePackageRequest.wrap(buildAwsValue())
}
object DeletePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DeletePackageRequest =
      zio.aws.elasticsearch.model.DeletePackageRequest(packageID)
    def packageID: PackageID
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest
  ) extends zio.aws.elasticsearch.model.DeletePackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.elasticsearch.model.primitives.PackageID(impl.packageID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest
  ): zio.aws.elasticsearch.model.DeletePackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
