package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoTune(
    autoTuneType: Optional[zio.aws.elasticsearch.model.AutoTuneType] =
      Optional.Absent,
    autoTuneDetails: Optional[zio.aws.elasticsearch.model.AutoTuneDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTune = {
    import AutoTune.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTune
      .builder()
      .optionallyWith(autoTuneType.map(value => value.unwrap))(_.autoTuneType)
      .optionallyWith(autoTuneDetails.map(value => value.buildAwsValue()))(
        _.autoTuneDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTune.ReadOnly =
    zio.aws.elasticsearch.model.AutoTune.wrap(buildAwsValue())
}
object AutoTune {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTune
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTune =
      zio.aws.elasticsearch.model.AutoTune(
        autoTuneType.map(value => value),
        autoTuneDetails.map(value => value.asEditable)
      )
    def autoTuneType: Optional[zio.aws.elasticsearch.model.AutoTuneType]
    def autoTuneDetails
        : Optional[zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly]
    def getAutoTuneType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.AutoTuneType] =
      AwsError.unwrapOptionField("autoTuneType", autoTuneType)
    def getAutoTuneDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneDetails", autoTuneDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTune
  ) extends zio.aws.elasticsearch.model.AutoTune.ReadOnly {
    override val autoTuneType
        : Optional[zio.aws.elasticsearch.model.AutoTuneType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTuneType())
        .map(value => zio.aws.elasticsearch.model.AutoTuneType.wrap(value))
    override val autoTuneDetails
        : Optional[zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTuneDetails())
        .map(value => zio.aws.elasticsearch.model.AutoTuneDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTune
  ): zio.aws.elasticsearch.model.AutoTune.ReadOnly = new Wrapper(impl)
}
