package zio.aws.elasticsearch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{
  Integer,
  UpdateTimestamp,
  GUID,
  ReservationToken
}
import scala.jdk.CollectionConverters._
final case class ReservedElasticsearchInstance(
    reservationName: Optional[ReservationToken] = Optional.Absent,
    reservedElasticsearchInstanceId: Optional[GUID] = Optional.Absent,
    reservedElasticsearchInstanceOfferingId: Optional[String] = Optional.Absent,
    elasticsearchInstanceType: Optional[
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = Optional.Absent,
    startTime: Optional[UpdateTimestamp] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    usagePrice: Optional[Double] = Optional.Absent,
    currencyCode: Optional[String] = Optional.Absent,
    elasticsearchInstanceCount: Optional[Integer] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    paymentOption: Optional[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ] = Optional.Absent,
    recurringCharges: Optional[
      Iterable[zio.aws.elasticsearch.model.RecurringCharge]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance = {
    import ReservedElasticsearchInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance
      .builder()
      .optionallyWith(
        reservationName.map(value =>
          ReservationToken.unwrap(value): java.lang.String
        )
      )(_.reservationName)
      .optionallyWith(
        reservedElasticsearchInstanceId.map(value =>
          GUID.unwrap(value): java.lang.String
        )
      )(_.reservedElasticsearchInstanceId)
      .optionallyWith(
        reservedElasticsearchInstanceOfferingId.map(value =>
          value: java.lang.String
        )
      )(_.reservedElasticsearchInstanceOfferingId)
      .optionallyWith(elasticsearchInstanceType.map(value => value.unwrap))(
        _.elasticsearchInstanceType
      )
      .optionallyWith(
        startTime.map(value => UpdateTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(
        elasticsearchInstanceCount.map(value => value: java.lang.Integer)
      )(_.elasticsearchInstanceCount)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly =
    zio.aws.elasticsearch.model.ReservedElasticsearchInstance
      .wrap(buildAwsValue())
}
object ReservedElasticsearchInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ReservedElasticsearchInstance =
      zio.aws.elasticsearch.model.ReservedElasticsearchInstance(
        reservationName.map(value => value),
        reservedElasticsearchInstanceId.map(value => value),
        reservedElasticsearchInstanceOfferingId.map(value => value),
        elasticsearchInstanceType.map(value => value),
        startTime.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        elasticsearchInstanceCount.map(value => value),
        state.map(value => value),
        paymentOption.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservationName: Optional[ReservationToken]
    def reservedElasticsearchInstanceId: Optional[GUID]
    def reservedElasticsearchInstanceOfferingId: Optional[String]
    def elasticsearchInstanceType
        : Optional[zio.aws.elasticsearch.model.ESPartitionInstanceType]
    def startTime: Optional[UpdateTimestamp]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def usagePrice: Optional[Double]
    def currencyCode: Optional[String]
    def elasticsearchInstanceCount: Optional[Integer]
    def state: Optional[String]
    def paymentOption: Optional[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ]
    def recurringCharges
        : Optional[List[zio.aws.elasticsearch.model.RecurringCharge.ReadOnly]]
    def getReservationName: ZIO[Any, AwsError, ReservationToken] =
      AwsError.unwrapOptionField("reservationName", reservationName)
    def getReservedElasticsearchInstanceId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField(
        "reservedElasticsearchInstanceId",
        reservedElasticsearchInstanceId
      )
    def getReservedElasticsearchInstanceOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedElasticsearchInstanceOfferingId",
        reservedElasticsearchInstanceOfferingId
      )
    def getElasticsearchInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = AwsError.unwrapOptionField(
      "elasticsearchInstanceType",
      elasticsearchInstanceType
    )
    def getStartTime: ZIO[Any, AwsError, UpdateTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getElasticsearchInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "elasticsearchInstanceCount",
        elasticsearchInstanceCount
      )
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getPaymentOption: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance
  ) extends zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly {
    override val reservationName: Optional[ReservationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservationName())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.ReservationToken(value)
        )
    override val reservedElasticsearchInstanceId: Optional[GUID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedElasticsearchInstanceId())
        .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val reservedElasticsearchInstanceOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedElasticsearchInstanceOfferingId())
        .map(value => value: String)
    override val elasticsearchInstanceType
        : Optional[zio.aws.elasticsearch.model.ESPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticsearchInstanceType())
        .map(value =>
          zio.aws.elasticsearch.model.ESPartitionInstanceType.wrap(value)
        )
    override val startTime: Optional[UpdateTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.UpdateTimestamp(value)
      )
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val usagePrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Double)
    override val currencyCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currencyCode())
      .map(value => value: String)
    override val elasticsearchInstanceCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticsearchInstanceCount())
        .map(value => value: Integer)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val paymentOption: Optional[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.paymentOption())
      .map(value =>
        zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
          .wrap(value)
      )
    override val recurringCharges
        : Optional[List[zio.aws.elasticsearch.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.RecurringCharge.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance
  ): zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly =
    new Wrapper(impl)
}
