package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters._
sealed trait OptionState {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.OptionState
}
object OptionState {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.OptionState
  ): zio.aws.elasticsearch.model.OptionState = value match {
    case software.amazon.awssdk.services.elasticsearch.model.OptionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.OptionState.REQUIRES_INDEX_DOCUMENTS =>
      val r = RequiresIndexDocuments
      r
    case software.amazon.awssdk.services.elasticsearch.model.OptionState.PROCESSING =>
      val r = Processing
      r
    case software.amazon.awssdk.services.elasticsearch.model.OptionState.ACTIVE =>
      val r = Active
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.OptionState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.OptionState =
      software.amazon.awssdk.services.elasticsearch.model.OptionState.UNKNOWN_TO_SDK_VERSION
  }
  case object RequiresIndexDocuments
      extends zio.aws.elasticsearch.model.OptionState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.OptionState =
      software.amazon.awssdk.services.elasticsearch.model.OptionState.REQUIRES_INDEX_DOCUMENTS
  }
  case object Processing extends zio.aws.elasticsearch.model.OptionState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.OptionState =
      software.amazon.awssdk.services.elasticsearch.model.OptionState.PROCESSING
  }
  case object Active extends zio.aws.elasticsearch.model.OptionState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.OptionState =
      software.amazon.awssdk.services.elasticsearch.model.OptionState.ACTIVE
  }
}
