package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters._
sealed trait InboundCrossClusterSearchConnectionStatusCode {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode
}
object InboundCrossClusterSearchConnectionStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode
  ): zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode =
    value match {
      case software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.PENDING_ACCEPTANCE =>
        val r = PENDING_ACCEPTANCE
        r
      case software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.APPROVED =>
        val r = APPROVED
        r
      case software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.REJECTING =>
        val r = REJECTING
        r
      case software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.REJECTED =>
        val r = REJECTED
        r
      case software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.DELETING =>
        val r = DELETING
        r
      case software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.DELETED =>
        val r = DELETED
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode =
      software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_ACCEPTANCE
      extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode =
      software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.PENDING_ACCEPTANCE
  }
  case object APPROVED
      extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode =
      software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.APPROVED
  }
  case object REJECTING
      extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode =
      software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.REJECTING
  }
  case object REJECTED
      extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode =
      software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.REJECTED
  }
  case object DELETING
      extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode =
      software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.DELETING
  }
  case object DELETED
      extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode =
      software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode.DELETED
  }
}
