package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ElasticsearchClusterConfigStatus(
    options: zio.aws.elasticsearch.model.ElasticsearchClusterConfig,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus = {
    import ElasticsearchClusterConfigStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.ReadOnly =
    zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus
      .wrap(buildAwsValue())
}
object ElasticsearchClusterConfigStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus =
      zio.aws.elasticsearch.model
        .ElasticsearchClusterConfigStatus(options.asEditable, status.asEditable)
    def options: zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus
  ) extends zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.ReadOnly {
    override val options
        : zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly =
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig
        .wrap(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus
  ): zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.ReadOnly =
    new Wrapper(impl)
}
