package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  RoleArn,
  IdentityPoolId,
  UserPoolId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CognitoOptions(
    enabled: Optional[Boolean] = Optional.Absent,
    userPoolId: Optional[UserPoolId] = Optional.Absent,
    identityPoolId: Optional[IdentityPoolId] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CognitoOptions = {
    import CognitoOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CognitoOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        userPoolId.map(value => UserPoolId.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.CognitoOptions.ReadOnly =
    zio.aws.elasticsearch.model.CognitoOptions.wrap(buildAwsValue())
}
object CognitoOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CognitoOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.CognitoOptions =
      zio.aws.elasticsearch.model.CognitoOptions(
        enabled.map(value => value),
        userPoolId.map(value => value),
        identityPoolId.map(value => value),
        roleArn.map(value => value)
      )
    def enabled: Optional[Boolean]
    def userPoolId: Optional[UserPoolId]
    def identityPoolId: Optional[IdentityPoolId]
    def roleArn: Optional[RoleArn]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getUserPoolId: ZIO[Any, AwsError, UserPoolId] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CognitoOptions
  ) extends zio.aws.elasticsearch.model.CognitoOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val userPoolId: Optional[UserPoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolId())
      .map(value => zio.aws.elasticsearch.model.primitives.UserPoolId(value))
    override val identityPoolId: Optional[IdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolId())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.IdentityPoolId(value)
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.elasticsearch.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CognitoOptions
  ): zio.aws.elasticsearch.model.CognitoOptions.ReadOnly = new Wrapper(impl)
}
