package zio.aws.elasticsearch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.DisableTimestamp
import scala.jdk.CollectionConverters._
final case class AdvancedSecurityOptions(
    enabled: Optional[Boolean] = Optional.Absent,
    internalUserDatabaseEnabled: Optional[Boolean] = Optional.Absent,
    samlOptions: Optional[zio.aws.elasticsearch.model.SAMLOptionsOutput] =
      Optional.Absent,
    anonymousAuthDisableDate: Optional[DisableTimestamp] = Optional.Absent,
    anonymousAuthEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions = {
    import AdvancedSecurityOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        internalUserDatabaseEnabled.map(value => value: java.lang.Boolean)
      )(_.internalUserDatabaseEnabled)
      .optionallyWith(samlOptions.map(value => value.buildAwsValue()))(
        _.samlOptions
      )
      .optionallyWith(
        anonymousAuthDisableDate.map(value =>
          DisableTimestamp.unwrap(value): Instant
        )
      )(_.anonymousAuthDisableDate)
      .optionallyWith(
        anonymousAuthEnabled.map(value => value: java.lang.Boolean)
      )(_.anonymousAuthEnabled)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly =
    zio.aws.elasticsearch.model.AdvancedSecurityOptions.wrap(buildAwsValue())
}
object AdvancedSecurityOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AdvancedSecurityOptions =
      zio.aws.elasticsearch.model.AdvancedSecurityOptions(
        enabled.map(value => value),
        internalUserDatabaseEnabled.map(value => value),
        samlOptions.map(value => value.asEditable),
        anonymousAuthDisableDate.map(value => value),
        anonymousAuthEnabled.map(value => value)
      )
    def enabled: Optional[Boolean]
    def internalUserDatabaseEnabled: Optional[Boolean]
    def samlOptions
        : Optional[zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly]
    def anonymousAuthDisableDate: Optional[DisableTimestamp]
    def anonymousAuthEnabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getInternalUserDatabaseEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "internalUserDatabaseEnabled",
        internalUserDatabaseEnabled
      )
    def getSamlOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly
    ] = AwsError.unwrapOptionField("samlOptions", samlOptions)
    def getAnonymousAuthDisableDate: ZIO[Any, AwsError, DisableTimestamp] =
      AwsError.unwrapOptionField(
        "anonymousAuthDisableDate",
        anonymousAuthDisableDate
      )
    def getAnonymousAuthEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("anonymousAuthEnabled", anonymousAuthEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
  ) extends zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val internalUserDatabaseEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.internalUserDatabaseEnabled())
        .map(value => value: Boolean)
    override val samlOptions
        : Optional[zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samlOptions())
        .map(value => zio.aws.elasticsearch.model.SAMLOptionsOutput.wrap(value))
    override val anonymousAuthDisableDate: Optional[DisableTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anonymousAuthDisableDate())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.DisableTimestamp(value)
        )
    override val anonymousAuthEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.anonymousAuthEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
  ): zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly = new Wrapper(
    impl
  )
}
