package zio.aws.elasticsearch
import zio.aws.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.elasticsearch.model.{
  DeleteOutboundCrossClusterSearchConnectionRequest,
  ListElasticsearchInstanceTypesRequest,
  AssociatePackageRequest,
  DescribeOutboundCrossClusterSearchConnectionsRequest,
  GetUpgradeHistoryRequest,
  DeleteElasticsearchDomainRequest,
  GetCompatibleElasticsearchVersionsRequest,
  DescribePackagesRequest,
  DescribeElasticsearchDomainConfigRequest,
  RejectInboundCrossClusterSearchConnectionRequest,
  DescribeElasticsearchDomainsRequest,
  ListTagsRequest,
  DescribeElasticsearchDomainRequest,
  UpgradeElasticsearchDomainRequest,
  DescribeDomainAutoTunesRequest,
  CancelElasticsearchServiceSoftwareUpdateRequest,
  ListElasticsearchVersionsRequest,
  ListPackagesForDomainRequest,
  DeletePackageRequest,
  GetPackageVersionHistoryRequest,
  CreatePackageRequest,
  AddTagsRequest,
  DescribeDomainChangeProgressRequest,
  ListDomainNamesRequest,
  DescribeElasticsearchInstanceTypeLimitsRequest,
  GetUpgradeStatusRequest,
  AcceptInboundCrossClusterSearchConnectionRequest,
  DescribeInboundCrossClusterSearchConnectionsRequest,
  PurchaseReservedElasticsearchInstanceOfferingRequest,
  CreateElasticsearchDomainRequest,
  CreateOutboundCrossClusterSearchConnectionRequest,
  DescribeReservedElasticsearchInstanceOfferingsRequest,
  ESPartitionInstanceType,
  StartElasticsearchServiceSoftwareUpdateRequest,
  DissociatePackageRequest,
  UpdateElasticsearchDomainConfigRequest,
  RemoveTagsRequest,
  ListDomainsForPackageRequest,
  DescribeReservedElasticsearchInstancesRequest,
  UpdatePackageRequest,
  DeleteInboundCrossClusterSearchConnectionRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient
import zio.stream.ZStream
import zio.aws.elasticsearch.model.primitives.ElasticsearchVersionString
object ElasticsearchMock extends Mock[Elasticsearch] {
  object DescribePackages
      extends Stream[
        DescribePackagesRequest,
        AwsError,
        zio.aws.elasticsearch.model.PackageDetails.ReadOnly
      ]
  object DescribePackagesPaginated
      extends Effect[
        DescribePackagesRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly
      ]
  object DeleteInboundCrossClusterSearchConnection
      extends Effect[
        DeleteInboundCrossClusterSearchConnectionRequest,
        AwsError,
        zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse.ReadOnly
      ]
  object DescribeElasticsearchDomains
      extends Effect[
        DescribeElasticsearchDomainsRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse.ReadOnly
      ]
  object AssociatePackage
      extends Effect[
        AssociatePackageRequest,
        AwsError,
        zio.aws.elasticsearch.model.AssociatePackageResponse.ReadOnly
      ]
  object DescribeReservedElasticsearchInstanceOfferings
      extends Stream[
        DescribeReservedElasticsearchInstanceOfferingsRequest,
        AwsError,
        zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly
      ]
  object DescribeReservedElasticsearchInstanceOfferingsPaginated
      extends Effect[
        DescribeReservedElasticsearchInstanceOfferingsRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse.ReadOnly
      ]
  object DescribeReservedElasticsearchInstances
      extends Stream[
        DescribeReservedElasticsearchInstancesRequest,
        AwsError,
        zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly
      ]
  object DescribeReservedElasticsearchInstancesPaginated
      extends Effect[
        DescribeReservedElasticsearchInstancesRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly
      ]
  object CreatePackage
      extends Effect[
        CreatePackageRequest,
        AwsError,
        zio.aws.elasticsearch.model.CreatePackageResponse.ReadOnly
      ]
  object ListTags
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.elasticsearch.model.ListTagsResponse.ReadOnly
      ]
  object AddTags extends Effect[AddTagsRequest, AwsError, Unit]
  object DissociatePackage
      extends Effect[
        DissociatePackageRequest,
        AwsError,
        zio.aws.elasticsearch.model.DissociatePackageResponse.ReadOnly
      ]
  object ListElasticsearchInstanceTypes
      extends Stream[
        ListElasticsearchInstanceTypesRequest,
        AwsError,
        ESPartitionInstanceType
      ]
  object ListElasticsearchInstanceTypesPaginated
      extends Effect[
        ListElasticsearchInstanceTypesRequest,
        AwsError,
        zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse.ReadOnly
      ]
  object GetCompatibleElasticsearchVersions
      extends Effect[
        GetCompatibleElasticsearchVersionsRequest,
        AwsError,
        zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse.ReadOnly
      ]
  object CreateElasticsearchDomain
      extends Effect[
        CreateElasticsearchDomainRequest,
        AwsError,
        zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse.ReadOnly
      ]
  object ListDomainsForPackage
      extends Stream[
        ListDomainsForPackageRequest,
        AwsError,
        zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
      ]
  object ListDomainsForPackagePaginated
      extends Effect[
        ListDomainsForPackageRequest,
        AwsError,
        zio.aws.elasticsearch.model.ListDomainsForPackageResponse.ReadOnly
      ]
  object DescribeDomainChangeProgress
      extends Effect[
        DescribeDomainChangeProgressRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeDomainChangeProgressResponse.ReadOnly
      ]
  object RemoveTags extends Effect[RemoveTagsRequest, AwsError, Unit]
  object GetUpgradeHistory
      extends Stream[
        GetUpgradeHistoryRequest,
        AwsError,
        zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly
      ]
  object GetUpgradeHistoryPaginated
      extends Effect[
        GetUpgradeHistoryRequest,
        AwsError,
        zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.ReadOnly
      ]
  object DescribeElasticsearchDomain
      extends Effect[
        DescribeElasticsearchDomainRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse.ReadOnly
      ]
  object DeleteOutboundCrossClusterSearchConnection
      extends Effect[
        DeleteOutboundCrossClusterSearchConnectionRequest,
        AwsError,
        ReadOnly
      ]
  object CreateOutboundCrossClusterSearchConnection
      extends Effect[
        CreateOutboundCrossClusterSearchConnectionRequest,
        AwsError,
        zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse.ReadOnly
      ]
  object DeleteElasticsearchDomain
      extends Effect[
        DeleteElasticsearchDomainRequest,
        AwsError,
        zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse.ReadOnly
      ]
  object ListPackagesForDomain
      extends Stream[
        ListPackagesForDomainRequest,
        AwsError,
        zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
      ]
  object ListPackagesForDomainPaginated
      extends Effect[
        ListPackagesForDomainRequest,
        AwsError,
        zio.aws.elasticsearch.model.ListPackagesForDomainResponse.ReadOnly
      ]
  object CancelElasticsearchServiceSoftwareUpdate
      extends Effect[
        CancelElasticsearchServiceSoftwareUpdateRequest,
        AwsError,
        zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly
      ]
  object GetPackageVersionHistory
      extends Effect[
        GetPackageVersionHistoryRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly,
          zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly
        ]
      ]
  object GetPackageVersionHistoryPaginated
      extends Effect[
        GetPackageVersionHistoryRequest,
        AwsError,
        zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly
      ]
  object StartElasticsearchServiceSoftwareUpdate
      extends Effect[
        StartElasticsearchServiceSoftwareUpdateRequest,
        AwsError,
        zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse.ReadOnly
      ]
  object DescribeOutboundCrossClusterSearchConnections
      extends Stream[
        DescribeOutboundCrossClusterSearchConnectionsRequest,
        AwsError,
        zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
      ]
  object DescribeOutboundCrossClusterSearchConnectionsPaginated
      extends Effect[
        DescribeOutboundCrossClusterSearchConnectionsRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse.ReadOnly
      ]
  object DescribeDomainAutoTunes
      extends Stream[
        DescribeDomainAutoTunesRequest,
        AwsError,
        zio.aws.elasticsearch.model.AutoTune.ReadOnly
      ]
  object DescribeDomainAutoTunesPaginated
      extends Effect[
        DescribeDomainAutoTunesRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse.ReadOnly
      ]
  object DescribeElasticsearchDomainConfig
      extends Effect[
        DescribeElasticsearchDomainConfigRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse.ReadOnly
      ]
  object UpdatePackage
      extends Effect[
        UpdatePackageRequest,
        AwsError,
        zio.aws.elasticsearch.model.UpdatePackageResponse.ReadOnly
      ]
  object DeletePackage
      extends Effect[
        DeletePackageRequest,
        AwsError,
        zio.aws.elasticsearch.model.DeletePackageResponse.ReadOnly
      ]
  object RejectInboundCrossClusterSearchConnection
      extends Effect[
        RejectInboundCrossClusterSearchConnectionRequest,
        AwsError,
        zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse.ReadOnly
      ]
  object UpgradeElasticsearchDomain
      extends Effect[
        UpgradeElasticsearchDomainRequest,
        AwsError,
        zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly
      ]
  object PurchaseReservedElasticsearchInstanceOffering
      extends Effect[
        PurchaseReservedElasticsearchInstanceOfferingRequest,
        AwsError,
        zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse.ReadOnly
      ]
  object GetUpgradeStatus
      extends Effect[
        GetUpgradeStatusRequest,
        AwsError,
        zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly
      ]
  object DeleteElasticsearchServiceRole extends Effect[Unit, AwsError, Unit]
  object UpdateElasticsearchDomainConfig
      extends Effect[
        UpdateElasticsearchDomainConfigRequest,
        AwsError,
        zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse.ReadOnly
      ]
  object ListDomainNames
      extends Effect[
        ListDomainNamesRequest,
        AwsError,
        zio.aws.elasticsearch.model.ListDomainNamesResponse.ReadOnly
      ]
  object DescribeInboundCrossClusterSearchConnections
      extends Stream[
        DescribeInboundCrossClusterSearchConnectionsRequest,
        AwsError,
        zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
      ]
  object DescribeInboundCrossClusterSearchConnectionsPaginated
      extends Effect[
        DescribeInboundCrossClusterSearchConnectionsRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly
      ]
  object AcceptInboundCrossClusterSearchConnection
      extends Effect[
        AcceptInboundCrossClusterSearchConnectionRequest,
        AwsError,
        zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse.ReadOnly
      ]
  object ListElasticsearchVersions
      extends Stream[
        ListElasticsearchVersionsRequest,
        AwsError,
        ElasticsearchVersionString
      ]
  object ListElasticsearchVersionsPaginated
      extends Effect[
        ListElasticsearchVersionsRequest,
        AwsError,
        zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse.ReadOnly
      ]
  object DescribeElasticsearchInstanceTypeLimits
      extends Effect[
        DescribeElasticsearchInstanceTypeLimitsRequest,
        AwsError,
        zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Elasticsearch] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Elasticsearch] { rts =>
        ZIO.succeed {
          new Elasticsearch {
            val api: ElasticsearchAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Elasticsearch = this
            def describePackages(request: DescribePackagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.elasticsearch.model.PackageDetails.ReadOnly
            ] = rts.unsafeRun(proxy(DescribePackages, request))
            def describePackagesPaginated(request: DescribePackagesRequest): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly
            ] = proxy(DescribePackagesPaginated, request)
            def deleteInboundCrossClusterSearchConnection(
                request: DeleteInboundCrossClusterSearchConnectionRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse.ReadOnly
            ] = proxy(DeleteInboundCrossClusterSearchConnection, request)
            def describeElasticsearchDomains(
                request: DescribeElasticsearchDomainsRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse.ReadOnly
            ] = proxy(DescribeElasticsearchDomains, request)
            def associatePackage(request: AssociatePackageRequest): IO[
              AwsError,
              zio.aws.elasticsearch.model.AssociatePackageResponse.ReadOnly
            ] = proxy(AssociatePackage, request)
            def describeReservedElasticsearchInstanceOfferings(
                request: DescribeReservedElasticsearchInstanceOfferingsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeReservedElasticsearchInstanceOfferings, request)
            )
            def describeReservedElasticsearchInstanceOfferingsPaginated(
                request: DescribeReservedElasticsearchInstanceOfferingsRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse.ReadOnly
            ] = proxy(
              DescribeReservedElasticsearchInstanceOfferingsPaginated,
              request
            )
            def describeReservedElasticsearchInstances(
                request: DescribeReservedElasticsearchInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeReservedElasticsearchInstances, request))
            def describeReservedElasticsearchInstancesPaginated(
                request: DescribeReservedElasticsearchInstancesRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly
            ] = proxy(DescribeReservedElasticsearchInstancesPaginated, request)
            def createPackage(request: CreatePackageRequest): IO[
              AwsError,
              zio.aws.elasticsearch.model.CreatePackageResponse.ReadOnly
            ] = proxy(CreatePackage, request)
            def listTags(request: ListTagsRequest): IO[
              AwsError,
              zio.aws.elasticsearch.model.ListTagsResponse.ReadOnly
            ] = proxy(ListTags, request)
            def addTags(request: AddTagsRequest): IO[AwsError, Unit] =
              proxy(AddTags, request)
            def dissociatePackage(request: DissociatePackageRequest): IO[
              AwsError,
              zio.aws.elasticsearch.model.DissociatePackageResponse.ReadOnly
            ] = proxy(DissociatePackage, request)
            def listElasticsearchInstanceTypes(
                request: ListElasticsearchInstanceTypesRequest
            ): ZStream[Any, AwsError, ESPartitionInstanceType] =
              rts.unsafeRun(proxy(ListElasticsearchInstanceTypes, request))
            def listElasticsearchInstanceTypesPaginated(
                request: ListElasticsearchInstanceTypesRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse.ReadOnly
            ] = proxy(ListElasticsearchInstanceTypesPaginated, request)
            def getCompatibleElasticsearchVersions(
                request: GetCompatibleElasticsearchVersionsRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse.ReadOnly
            ] = proxy(GetCompatibleElasticsearchVersions, request)
            def createElasticsearchDomain(
                request: CreateElasticsearchDomainRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse.ReadOnly
            ] = proxy(CreateElasticsearchDomain, request)
            def listDomainsForPackage(
                request: ListDomainsForPackageRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
            ] = rts.unsafeRun(proxy(ListDomainsForPackage, request))
            def listDomainsForPackagePaginated(
                request: ListDomainsForPackageRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.ListDomainsForPackageResponse.ReadOnly
            ] = proxy(ListDomainsForPackagePaginated, request)
            def describeDomainChangeProgress(
                request: DescribeDomainChangeProgressRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeDomainChangeProgressResponse.ReadOnly
            ] = proxy(DescribeDomainChangeProgress, request)
            def removeTags(request: RemoveTagsRequest): IO[AwsError, Unit] =
              proxy(RemoveTags, request)
            def getUpgradeHistory(request: GetUpgradeHistoryRequest): ZStream[
              Any,
              AwsError,
              zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly
            ] = rts.unsafeRun(proxy(GetUpgradeHistory, request))
            def getUpgradeHistoryPaginated(
                request: GetUpgradeHistoryRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.ReadOnly
            ] = proxy(GetUpgradeHistoryPaginated, request)
            def describeElasticsearchDomain(
                request: DescribeElasticsearchDomainRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse.ReadOnly
            ] = proxy(DescribeElasticsearchDomain, request)
            def deleteOutboundCrossClusterSearchConnection(
                request: DeleteOutboundCrossClusterSearchConnectionRequest
            ): IO[AwsError, ReadOnly] =
              proxy(DeleteOutboundCrossClusterSearchConnection, request)
            def createOutboundCrossClusterSearchConnection(
                request: CreateOutboundCrossClusterSearchConnectionRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse.ReadOnly
            ] = proxy(CreateOutboundCrossClusterSearchConnection, request)
            def deleteElasticsearchDomain(
                request: DeleteElasticsearchDomainRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse.ReadOnly
            ] = proxy(DeleteElasticsearchDomain, request)
            def listPackagesForDomain(
                request: ListPackagesForDomainRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
            ] = rts.unsafeRun(proxy(ListPackagesForDomain, request))
            def listPackagesForDomainPaginated(
                request: ListPackagesForDomainRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.ListPackagesForDomainResponse.ReadOnly
            ] = proxy(ListPackagesForDomainPaginated, request)
            def cancelElasticsearchServiceSoftwareUpdate(
                request: CancelElasticsearchServiceSoftwareUpdateRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly
            ] = proxy(CancelElasticsearchServiceSoftwareUpdate, request)
            def getPackageVersionHistory(
                request: GetPackageVersionHistoryRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly,
              zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly
            ]] = proxy(GetPackageVersionHistory, request)
            def getPackageVersionHistoryPaginated(
                request: GetPackageVersionHistoryRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly
            ] = proxy(GetPackageVersionHistoryPaginated, request)
            def startElasticsearchServiceSoftwareUpdate(
                request: StartElasticsearchServiceSoftwareUpdateRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse.ReadOnly
            ] = proxy(StartElasticsearchServiceSoftwareUpdate, request)
            def describeOutboundCrossClusterSearchConnections(
                request: DescribeOutboundCrossClusterSearchConnectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeOutboundCrossClusterSearchConnections, request)
            )
            def describeOutboundCrossClusterSearchConnectionsPaginated(
                request: DescribeOutboundCrossClusterSearchConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse.ReadOnly
            ] = proxy(
              DescribeOutboundCrossClusterSearchConnectionsPaginated,
              request
            )
            def describeDomainAutoTunes(
                request: DescribeDomainAutoTunesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.elasticsearch.model.AutoTune.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeDomainAutoTunes, request))
            def describeDomainAutoTunesPaginated(
                request: DescribeDomainAutoTunesRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse.ReadOnly
            ] = proxy(DescribeDomainAutoTunesPaginated, request)
            def describeElasticsearchDomainConfig(
                request: DescribeElasticsearchDomainConfigRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse.ReadOnly
            ] = proxy(DescribeElasticsearchDomainConfig, request)
            def updatePackage(request: UpdatePackageRequest): IO[
              AwsError,
              zio.aws.elasticsearch.model.UpdatePackageResponse.ReadOnly
            ] = proxy(UpdatePackage, request)
            def deletePackage(request: DeletePackageRequest): IO[
              AwsError,
              zio.aws.elasticsearch.model.DeletePackageResponse.ReadOnly
            ] = proxy(DeletePackage, request)
            def rejectInboundCrossClusterSearchConnection(
                request: RejectInboundCrossClusterSearchConnectionRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse.ReadOnly
            ] = proxy(RejectInboundCrossClusterSearchConnection, request)
            def upgradeElasticsearchDomain(
                request: UpgradeElasticsearchDomainRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly
            ] = proxy(UpgradeElasticsearchDomain, request)
            def purchaseReservedElasticsearchInstanceOffering(
                request: PurchaseReservedElasticsearchInstanceOfferingRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse.ReadOnly
            ] = proxy(PurchaseReservedElasticsearchInstanceOffering, request)
            def getUpgradeStatus(request: GetUpgradeStatusRequest): IO[
              AwsError,
              zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly
            ] = proxy(GetUpgradeStatus, request)
            def deleteElasticsearchServiceRole(): IO[AwsError, Unit] =
              proxy(DeleteElasticsearchServiceRole)
            def updateElasticsearchDomainConfig(
                request: UpdateElasticsearchDomainConfigRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse.ReadOnly
            ] = proxy(UpdateElasticsearchDomainConfig, request)
            def listDomainNames(request: ListDomainNamesRequest): IO[
              AwsError,
              zio.aws.elasticsearch.model.ListDomainNamesResponse.ReadOnly
            ] = proxy(ListDomainNames, request)
            def describeInboundCrossClusterSearchConnections(
                request: DescribeInboundCrossClusterSearchConnectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeInboundCrossClusterSearchConnections, request)
            )
            def describeInboundCrossClusterSearchConnectionsPaginated(
                request: DescribeInboundCrossClusterSearchConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly
            ] = proxy(
              DescribeInboundCrossClusterSearchConnectionsPaginated,
              request
            )
            def acceptInboundCrossClusterSearchConnection(
                request: AcceptInboundCrossClusterSearchConnectionRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse.ReadOnly
            ] = proxy(AcceptInboundCrossClusterSearchConnection, request)
            def listElasticsearchVersions(
                request: ListElasticsearchVersionsRequest
            ): ZStream[Any, AwsError, ElasticsearchVersionString] =
              rts.unsafeRun(proxy(ListElasticsearchVersions, request))
            def listElasticsearchVersionsPaginated(
                request: ListElasticsearchVersionsRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse.ReadOnly
            ] = proxy(ListElasticsearchVersionsPaginated, request)
            def describeElasticsearchInstanceTypeLimits(
                request: DescribeElasticsearchInstanceTypeLimitsRequest
            ): IO[
              AwsError,
              zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse.ReadOnly
            ] = proxy(DescribeElasticsearchInstanceTypeLimits, request)
          }
        }
      }
    }
  }
}
