package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{Password, Username, ARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MasterUserOptions(
    masterUserARN: Optional[ARN] = Optional.Absent,
    masterUserName: Optional[Username] = Optional.Absent,
    masterUserPassword: Optional[Password] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.MasterUserOptions = {
    import MasterUserOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.MasterUserOptions
      .builder()
      .optionallyWith(
        masterUserARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.masterUserARN)
      .optionallyWith(
        masterUserName.map(value => Username.unwrap(value): java.lang.String)
      )(_.masterUserName)
      .optionallyWith(
        masterUserPassword.map(value =>
          Password.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.MasterUserOptions.ReadOnly =
    zio.aws.elasticsearch.model.MasterUserOptions.wrap(buildAwsValue())
}
object MasterUserOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.MasterUserOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.MasterUserOptions =
      zio.aws.elasticsearch.model.MasterUserOptions(
        masterUserARN.map(value => value),
        masterUserName.map(value => value),
        masterUserPassword.map(value => value)
      )
    def masterUserARN: Optional[ARN]
    def masterUserName: Optional[Username]
    def masterUserPassword: Optional[Password]
    def getMasterUserARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("masterUserARN", masterUserARN)
    def getMasterUserName: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("masterUserName", masterUserName)
    def getMasterUserPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.MasterUserOptions
  ) extends zio.aws.elasticsearch.model.MasterUserOptions.ReadOnly {
    override val masterUserARN: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserARN())
      .map(value => zio.aws.elasticsearch.model.primitives.ARN(value))
    override val masterUserName: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserName())
      .map(value => zio.aws.elasticsearch.model.primitives.Username(value))
    override val masterUserPassword: Optional[Password] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => zio.aws.elasticsearch.model.primitives.Password(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.MasterUserOptions
  ): zio.aws.elasticsearch.model.MasterUserOptions.ReadOnly = new Wrapper(impl)
}
