package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.CrossClusterSearchConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InboundCrossClusterSearchConnection(
    sourceDomainInfo: Optional[zio.aws.elasticsearch.model.DomainInformation] =
      Optional.Absent,
    destinationDomainInfo: Optional[
      zio.aws.elasticsearch.model.DomainInformation
    ] = Optional.Absent,
    crossClusterSearchConnectionId: Optional[CrossClusterSearchConnectionId] =
      Optional.Absent,
    connectionStatus: Optional[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection = {
    import InboundCrossClusterSearchConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection
      .builder()
      .optionallyWith(sourceDomainInfo.map(value => value.buildAwsValue()))(
        _.sourceDomainInfo
      )
      .optionallyWith(
        destinationDomainInfo.map(value => value.buildAwsValue())
      )(_.destinationDomainInfo)
      .optionallyWith(
        crossClusterSearchConnectionId.map(value =>
          CrossClusterSearchConnectionId.unwrap(value): java.lang.String
        )
      )(_.crossClusterSearchConnectionId)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly =
    zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
      .wrap(buildAwsValue())
}
object InboundCrossClusterSearchConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection =
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection(
        sourceDomainInfo.map(value => value.asEditable),
        destinationDomainInfo.map(value => value.asEditable),
        crossClusterSearchConnectionId.map(value => value),
        connectionStatus.map(value => value.asEditable)
      )
    def sourceDomainInfo
        : Optional[zio.aws.elasticsearch.model.DomainInformation.ReadOnly]
    def destinationDomainInfo
        : Optional[zio.aws.elasticsearch.model.DomainInformation.ReadOnly]
    def crossClusterSearchConnectionId: Optional[CrossClusterSearchConnectionId]
    def connectionStatus: Optional[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus.ReadOnly
    ]
    def getSourceDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] = AwsError.unwrapOptionField("sourceDomainInfo", sourceDomainInfo)
    def getDestinationDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] =
      AwsError.unwrapOptionField("destinationDomainInfo", destinationDomainInfo)
    def getCrossClusterSearchConnectionId
        : ZIO[Any, AwsError, CrossClusterSearchConnectionId] =
      AwsError.unwrapOptionField(
        "crossClusterSearchConnectionId",
        crossClusterSearchConnectionId
      )
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection
  ) extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly {
    override val sourceDomainInfo
        : Optional[zio.aws.elasticsearch.model.DomainInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDomainInfo())
        .map(value => zio.aws.elasticsearch.model.DomainInformation.wrap(value))
    override val destinationDomainInfo
        : Optional[zio.aws.elasticsearch.model.DomainInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationDomainInfo())
        .map(value => zio.aws.elasticsearch.model.DomainInformation.wrap(value))
    override val crossClusterSearchConnectionId
        : Optional[CrossClusterSearchConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.crossClusterSearchConnectionId())
      .map(value =>
        zio.aws.elasticsearch.model.primitives
          .CrossClusterSearchConnectionId(value)
      )
    override val connectionStatus: Optional[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionStatus())
      .map(value =>
        zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection
  ): zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly =
    new Wrapper(impl)
}
