package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDomainsForPackageResponse(
    domainPackageDetailsList: Optional[
      Iterable[zio.aws.elasticsearch.model.DomainPackageDetails]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse = {
    import ListDomainsForPackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse
      .builder()
      .optionallyWith(
        domainPackageDetailsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainPackageDetailsList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListDomainsForPackageResponse.ReadOnly =
    zio.aws.elasticsearch.model.ListDomainsForPackageResponse
      .wrap(buildAwsValue())
}
object ListDomainsForPackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListDomainsForPackageResponse =
      zio.aws.elasticsearch.model.ListDomainsForPackageResponse(
        domainPackageDetailsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def domainPackageDetailsList: Optional[
      List[zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getDomainPackageDetailsList: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainPackageDetailsList",
      domainPackageDetailsList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse
  ) extends zio.aws.elasticsearch.model.ListDomainsForPackageResponse.ReadOnly {
    override val domainPackageDetailsList: Optional[
      List[zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainPackageDetailsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.DomainPackageDetails.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse
  ): zio.aws.elasticsearch.model.ListDomainsForPackageResponse.ReadOnly =
    new Wrapper(impl)
}
