package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeElasticsearchDomainResponse(
    domainStatus: zio.aws.elasticsearch.model.ElasticsearchDomainStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse = {
    import DescribeElasticsearchDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse
      .builder()
      .domainStatus(domainStatus.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse
      .wrap(buildAwsValue())
}
object DescribeElasticsearchDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse =
      zio.aws.elasticsearch.model
        .DescribeElasticsearchDomainResponse(domainStatus.asEditable)
    def domainStatus
        : zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly
    def getDomainStatus: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly
    ] = ZIO.succeed(domainStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse
  ) extends zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse.ReadOnly {
    override val domainStatus
        : zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly =
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus
        .wrap(impl.domainStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse
  ): zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse.ReadOnly =
    new Wrapper(impl)
}
