package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{DomainName, PackageID}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociatePackageRequest(
    packageID: PackageID,
    domainName: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest = {
    import AssociatePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AssociatePackageRequest.ReadOnly =
    zio.aws.elasticsearch.model.AssociatePackageRequest.wrap(buildAwsValue())
}
object AssociatePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AssociatePackageRequest =
      zio.aws.elasticsearch.model.AssociatePackageRequest(packageID, domainName)
    def packageID: PackageID
    def domainName: DomainName
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest
  ) extends zio.aws.elasticsearch.model.AssociatePackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.elasticsearch.model.primitives.PackageID(impl.packageID())
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest
  ): zio.aws.elasticsearch.model.AssociatePackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
