package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{
  NextToken,
  MaxResults,
  DomainName,
  ElasticsearchVersionString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListElasticsearchInstanceTypesRequest(
    elasticsearchVersion: ElasticsearchVersionString,
    domainName: Optional[DomainName] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest = {
    import ListElasticsearchInstanceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest
      .builder()
      .elasticsearchVersion(
        ElasticsearchVersionString.unwrap(
          elasticsearchVersion
        ): java.lang.String
      )
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest.ReadOnly =
    zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest
      .wrap(buildAwsValue())
}
object ListElasticsearchInstanceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest =
      zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest(
        elasticsearchVersion,
        domainName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def elasticsearchVersion: ElasticsearchVersionString
    def domainName: Optional[DomainName]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getElasticsearchVersion: ZIO[Any, Nothing, ElasticsearchVersionString] =
      ZIO.succeed(elasticsearchVersion)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest
  ) extends zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest.ReadOnly {
    override val elasticsearchVersion: ElasticsearchVersionString =
      zio.aws.elasticsearch.model.primitives
        .ElasticsearchVersionString(impl.elasticsearchVersion())
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainName(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest
  ): zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest.ReadOnly =
    new Wrapper(impl)
}
