package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoTuneDetails(
    scheduledAutoTuneDetails: Optional[
      zio.aws.elasticsearch.model.ScheduledAutoTuneDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails = {
    import AutoTuneDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails
      .builder()
      .optionallyWith(
        scheduledAutoTuneDetails.map(value => value.buildAwsValue())
      )(_.scheduledAutoTuneDetails)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneDetails.wrap(buildAwsValue())
}
object AutoTuneDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneDetails =
      zio.aws.elasticsearch.model.AutoTuneDetails(
        scheduledAutoTuneDetails.map(value => value.asEditable)
      )
    def scheduledAutoTuneDetails: Optional[
      zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly
    ]
    def getScheduledAutoTuneDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduledAutoTuneDetails",
      scheduledAutoTuneDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails
  ) extends zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly {
    override val scheduledAutoTuneDetails: Optional[
      zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledAutoTuneDetails())
      .map(value =>
        zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails
  ): zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly = new Wrapper(impl)
}
