package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.ElasticsearchVersionString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ElasticsearchVersionStatus(
    options: ElasticsearchVersionString,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus = {
    import ElasticsearchVersionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus
      .builder()
      .options(ElasticsearchVersionString.unwrap(options): java.lang.String)
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ElasticsearchVersionStatus.ReadOnly =
    zio.aws.elasticsearch.model.ElasticsearchVersionStatus.wrap(buildAwsValue())
}
object ElasticsearchVersionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ElasticsearchVersionStatus =
      zio.aws.elasticsearch.model
        .ElasticsearchVersionStatus(options, status.asEditable)
    def options: ElasticsearchVersionString
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[Any, Nothing, ElasticsearchVersionString] =
      ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus
  ) extends zio.aws.elasticsearch.model.ElasticsearchVersionStatus.ReadOnly {
    override val options: ElasticsearchVersionString =
      zio.aws.elasticsearch.model.primitives
        .ElasticsearchVersionString(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus
  ): zio.aws.elasticsearch.model.ElasticsearchVersionStatus.ReadOnly =
    new Wrapper(impl)
}
