package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{GUID, DomainName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDomainChangeProgressRequest(
    domainName: DomainName,
    changeId: Optional[GUID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressRequest = {
    import DescribeDomainChangeProgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        changeId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.changeId)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeDomainChangeProgressRequest.ReadOnly =
    zio.aws.elasticsearch.model.DescribeDomainChangeProgressRequest
      .wrap(buildAwsValue())
}
object DescribeDomainChangeProgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeDomainChangeProgressRequest =
      zio.aws.elasticsearch.model.DescribeDomainChangeProgressRequest(
        domainName,
        changeId.map(value => value)
      )
    def domainName: DomainName
    def changeId: Optional[GUID]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getChangeId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("changeId", changeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressRequest
  ) extends zio.aws.elasticsearch.model.DescribeDomainChangeProgressRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val changeId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.changeId())
      .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressRequest
  ): zio.aws.elasticsearch.model.DescribeDomainChangeProgressRequest.ReadOnly =
    new Wrapper(impl)
}
