package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.ARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsRequest(arn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest = {
    import ListTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest
      .builder()
      .arn(ARN.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ListTagsRequest.ReadOnly =
    zio.aws.elasticsearch.model.ListTagsRequest.wrap(buildAwsValue())
}
object ListTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListTagsRequest =
      zio.aws.elasticsearch.model.ListTagsRequest(arn)
    def arn: ARN
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest
  ) extends zio.aws.elasticsearch.model.ListTagsRequest.ReadOnly {
    override val arn: ARN =
      zio.aws.elasticsearch.model.primitives.ARN(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest
  ): zio.aws.elasticsearch.model.ListTagsRequest.ReadOnly = new Wrapper(impl)
}
