package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.Issue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpgradeStepItem(
    upgradeStep: Optional[zio.aws.elasticsearch.model.UpgradeStep] =
      Optional.Absent,
    upgradeStepStatus: Optional[zio.aws.elasticsearch.model.UpgradeStatus] =
      Optional.Absent,
    issues: Optional[Iterable[Issue]] = Optional.Absent,
    progressPercent: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem = {
    import UpgradeStepItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem
      .builder()
      .optionallyWith(upgradeStep.map(value => value.unwrap))(_.upgradeStep)
      .optionallyWith(upgradeStepStatus.map(value => value.unwrap))(
        _.upgradeStepStatus
      )
      .optionallyWith(
        issues.map(value =>
          value.map { item =>
            Issue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.issues)
      .optionallyWith(progressPercent.map(value => value: java.lang.Double))(
        _.progressPercent
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.UpgradeStepItem.ReadOnly =
    zio.aws.elasticsearch.model.UpgradeStepItem.wrap(buildAwsValue())
}
object UpgradeStepItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.UpgradeStepItem =
      zio.aws.elasticsearch.model.UpgradeStepItem(
        upgradeStep.map(value => value),
        upgradeStepStatus.map(value => value),
        issues.map(value => value),
        progressPercent.map(value => value)
      )
    def upgradeStep: Optional[zio.aws.elasticsearch.model.UpgradeStep]
    def upgradeStepStatus: Optional[zio.aws.elasticsearch.model.UpgradeStatus]
    def issues: Optional[List[Issue]]
    def progressPercent: Optional[Double]
    def getUpgradeStep
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.UpgradeStep] =
      AwsError.unwrapOptionField("upgradeStep", upgradeStep)
    def getUpgradeStepStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.UpgradeStatus] =
      AwsError.unwrapOptionField("upgradeStepStatus", upgradeStepStatus)
    def getIssues: ZIO[Any, AwsError, List[Issue]] =
      AwsError.unwrapOptionField("issues", issues)
    def getProgressPercent: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem
  ) extends zio.aws.elasticsearch.model.UpgradeStepItem.ReadOnly {
    override val upgradeStep
        : Optional[zio.aws.elasticsearch.model.UpgradeStep] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upgradeStep())
        .map(value => zio.aws.elasticsearch.model.UpgradeStep.wrap(value))
    override val upgradeStepStatus
        : Optional[zio.aws.elasticsearch.model.UpgradeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upgradeStepStatus())
        .map(value => zio.aws.elasticsearch.model.UpgradeStatus.wrap(value))
    override val issues: Optional[List[Issue]] = zio.aws.core.internal
      .optionalFromNullable(impl.issues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.primitives.Issue(item)
        }.toList
      )
    override val progressPercent: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.progressPercent())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem
  ): zio.aws.elasticsearch.model.UpgradeStepItem.ReadOnly = new Wrapper(impl)
}
