package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartElasticsearchServiceSoftwareUpdateResponse(
    serviceSoftwareOptions: Option[
      zio.aws.elasticsearch.model.ServiceSoftwareOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse = {
    import StartElasticsearchServiceSoftwareUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse
      .builder()
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse.ReadOnly =
    zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse
      .wrap(buildAwsValue())
}
object StartElasticsearchServiceSoftwareUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse =
      zio.aws.elasticsearch.model
        .StartElasticsearchServiceSoftwareUpdateResponse(
          serviceSoftwareOptions.map(value => value.asEditable)
        )
    def serviceSoftwareOptions
        : Option[zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly]
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse
  ) extends zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse.ReadOnly {
    override val serviceSoftwareOptions
        : Option[zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly] =
      scala
        .Option(impl.serviceSoftwareOptions())
        .map(value =>
          zio.aws.elasticsearch.model.ServiceSoftwareOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse
  ): zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse.ReadOnly =
    new Wrapper(impl)
}
