package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceLimits(
    instanceCountLimits: Option[
      zio.aws.elasticsearch.model.InstanceCountLimits
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.InstanceLimits = {
    import InstanceLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.InstanceLimits
      .builder()
      .optionallyWith(instanceCountLimits.map(value => value.buildAwsValue()))(
        _.instanceCountLimits
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.InstanceLimits.ReadOnly =
    zio.aws.elasticsearch.model.InstanceLimits.wrap(buildAwsValue())
}
object InstanceLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.InstanceLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.InstanceLimits =
      zio.aws.elasticsearch.model
        .InstanceLimits(instanceCountLimits.map(value => value.asEditable))
    def instanceCountLimits
        : Option[zio.aws.elasticsearch.model.InstanceCountLimits.ReadOnly]
    def getInstanceCountLimits: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.InstanceCountLimits.ReadOnly
    ] = AwsError.unwrapOptionField("instanceCountLimits", instanceCountLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.InstanceLimits
  ) extends zio.aws.elasticsearch.model.InstanceLimits.ReadOnly {
    override val instanceCountLimits
        : Option[zio.aws.elasticsearch.model.InstanceCountLimits.ReadOnly] =
      scala
        .Option(impl.instanceCountLimits())
        .map(value =>
          zio.aws.elasticsearch.model.InstanceCountLimits.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.InstanceLimits
  ): zio.aws.elasticsearch.model.InstanceLimits.ReadOnly = new Wrapper(impl)
}
