package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.PackageID
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPackageVersionHistoryResponse(
    packageID: Option[PackageID] = None,
    packageVersionHistoryList: Option[
      Iterable[zio.aws.elasticsearch.model.PackageVersionHistory]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse = {
    import GetPackageVersionHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse
      .builder()
      .optionallyWith(
        packageID.map(value => PackageID.unwrap(value): java.lang.String)
      )(_.packageID)
      .optionallyWith(
        packageVersionHistoryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packageVersionHistoryList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly =
    zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse
      .wrap(buildAwsValue())
}
object GetPackageVersionHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse =
      zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse(
        packageID.map(value => value),
        packageVersionHistoryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def packageID: Option[PackageID]
    def packageVersionHistoryList: Option[
      List[zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly]
    ]
    def nextToken: Option[String]
    def getPackageID: ZIO[Any, AwsError, PackageID] =
      AwsError.unwrapOptionField("packageID", packageID)
    def getPackageVersionHistoryList: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "packageVersionHistoryList",
      packageVersionHistoryList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse
  ) extends zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly {
    override val packageID: Option[PackageID] = scala
      .Option(impl.packageID())
      .map(value => zio.aws.elasticsearch.model.primitives.PackageID(value))
    override val packageVersionHistoryList: Option[
      List[zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly]
    ] = scala
      .Option(impl.packageVersionHistoryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.PackageVersionHistory.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse
  ): zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
