package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.ElasticsearchVersionString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CompatibleVersionsMap(
    sourceVersion: Option[ElasticsearchVersionString] = None,
    targetVersions: Option[Iterable[ElasticsearchVersionString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CompatibleVersionsMap = {
    import CompatibleVersionsMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CompatibleVersionsMap
      .builder()
      .optionallyWith(
        sourceVersion.map(value =>
          ElasticsearchVersionString.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .optionallyWith(
        targetVersions.map(value =>
          value.map { item =>
            ElasticsearchVersionString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetVersions)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.CompatibleVersionsMap.ReadOnly =
    zio.aws.elasticsearch.model.CompatibleVersionsMap.wrap(buildAwsValue())
}
object CompatibleVersionsMap {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CompatibleVersionsMap
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.CompatibleVersionsMap =
      zio.aws.elasticsearch.model.CompatibleVersionsMap(
        sourceVersion.map(value => value),
        targetVersions.map(value => value)
      )
    def sourceVersion: Option[ElasticsearchVersionString]
    def targetVersions: Option[List[ElasticsearchVersionString]]
    def getSourceVersion: ZIO[Any, AwsError, ElasticsearchVersionString] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getTargetVersions
        : ZIO[Any, AwsError, List[ElasticsearchVersionString]] =
      AwsError.unwrapOptionField("targetVersions", targetVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CompatibleVersionsMap
  ) extends zio.aws.elasticsearch.model.CompatibleVersionsMap.ReadOnly {
    override val sourceVersion: Option[ElasticsearchVersionString] = scala
      .Option(impl.sourceVersion())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.ElasticsearchVersionString(value)
      )
    override val targetVersions: Option[List[ElasticsearchVersionString]] =
      scala
        .Option(impl.targetVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.primitives
              .ElasticsearchVersionString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CompatibleVersionsMap
  ): zio.aws.elasticsearch.model.CompatibleVersionsMap.ReadOnly = new Wrapper(
    impl
  )
}
