package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters._
sealed trait PackageType {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.PackageType
}
object PackageType {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.PackageType
  ): zio.aws.elasticsearch.model.PackageType = value match {
    case software.amazon.awssdk.services.elasticsearch.model.PackageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.PackageType.TXT_DICTIONARY =>
      val r = `TXT-DICTIONARY`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageType =
      software.amazon.awssdk.services.elasticsearch.model.PackageType.UNKNOWN_TO_SDK_VERSION
  }
  case object `TXT-DICTIONARY` extends zio.aws.elasticsearch.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.PackageType =
      software.amazon.awssdk.services.elasticsearch.model.PackageType.TXT_DICTIONARY
  }
}
