package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.Issue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpgradeStepItem(
    upgradeStep: Option[zio.aws.elasticsearch.model.UpgradeStep] = None,
    upgradeStepStatus: Option[zio.aws.elasticsearch.model.UpgradeStatus] = None,
    issues: Option[Iterable[Issue]] = None,
    progressPercent: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem = {
    import UpgradeStepItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem
      .builder()
      .optionallyWith(upgradeStep.map(value => value.unwrap))(_.upgradeStep)
      .optionallyWith(upgradeStepStatus.map(value => value.unwrap))(
        _.upgradeStepStatus
      )
      .optionallyWith(
        issues.map(value =>
          value.map { item =>
            Issue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.issues)
      .optionallyWith(progressPercent.map(value => value: java.lang.Double))(
        _.progressPercent
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.UpgradeStepItem.ReadOnly =
    zio.aws.elasticsearch.model.UpgradeStepItem.wrap(buildAwsValue())
}
object UpgradeStepItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.UpgradeStepItem =
      zio.aws.elasticsearch.model.UpgradeStepItem(
        upgradeStep.map(value => value),
        upgradeStepStatus.map(value => value),
        issues.map(value => value),
        progressPercent.map(value => value)
      )
    def upgradeStep: Option[zio.aws.elasticsearch.model.UpgradeStep]
    def upgradeStepStatus: Option[zio.aws.elasticsearch.model.UpgradeStatus]
    def issues: Option[List[Issue]]
    def progressPercent: Option[Double]
    def getUpgradeStep
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.UpgradeStep] =
      AwsError.unwrapOptionField("upgradeStep", upgradeStep)
    def getUpgradeStepStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.UpgradeStatus] =
      AwsError.unwrapOptionField("upgradeStepStatus", upgradeStepStatus)
    def getIssues: ZIO[Any, AwsError, List[Issue]] =
      AwsError.unwrapOptionField("issues", issues)
    def getProgressPercent: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem
  ) extends zio.aws.elasticsearch.model.UpgradeStepItem.ReadOnly {
    override val upgradeStep: Option[zio.aws.elasticsearch.model.UpgradeStep] =
      scala
        .Option(impl.upgradeStep())
        .map(value => zio.aws.elasticsearch.model.UpgradeStep.wrap(value))
    override val upgradeStepStatus
        : Option[zio.aws.elasticsearch.model.UpgradeStatus] = scala
      .Option(impl.upgradeStepStatus())
      .map(value => zio.aws.elasticsearch.model.UpgradeStatus.wrap(value))
    override val issues: Option[List[Issue]] = scala
      .Option(impl.issues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.primitives.Issue(item)
        }.toList
      )
    override val progressPercent: Option[Double] =
      scala.Option(impl.progressPercent()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem
  ): zio.aws.elasticsearch.model.UpgradeStepItem.ReadOnly = new Wrapper(impl)
}
