package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  CommitMessage,
  PackageDescription,
  PackageID
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdatePackageRequest(
    packageID: PackageID,
    packageSource: zio.aws.elasticsearch.model.PackageSource,
    packageDescription: Option[PackageDescription] = None,
    commitMessage: Option[CommitMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest = {
    import UpdatePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .packageSource(packageSource.buildAwsValue())
      .optionallyWith(
        packageDescription.map(value =>
          PackageDescription.unwrap(value): java.lang.String
        )
      )(_.packageDescription)
      .optionallyWith(
        commitMessage.map(value =>
          CommitMessage.unwrap(value): java.lang.String
        )
      )(_.commitMessage)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.UpdatePackageRequest.ReadOnly =
    zio.aws.elasticsearch.model.UpdatePackageRequest.wrap(buildAwsValue())
}
object UpdatePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.UpdatePackageRequest =
      zio.aws.elasticsearch.model.UpdatePackageRequest(
        packageID,
        packageSource.asEditable,
        packageDescription.map(value => value),
        commitMessage.map(value => value)
      )
    def packageID: PackageID
    def packageSource: zio.aws.elasticsearch.model.PackageSource.ReadOnly
    def packageDescription: Option[PackageDescription]
    def commitMessage: Option[CommitMessage]
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
    def getPackageSource: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.PackageSource.ReadOnly
    ] = ZIO.succeed(packageSource)
    def getPackageDescription: ZIO[Any, AwsError, PackageDescription] =
      AwsError.unwrapOptionField("packageDescription", packageDescription)
    def getCommitMessage: ZIO[Any, AwsError, CommitMessage] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest
  ) extends zio.aws.elasticsearch.model.UpdatePackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.elasticsearch.model.primitives.PackageID(impl.packageID())
    override val packageSource
        : zio.aws.elasticsearch.model.PackageSource.ReadOnly =
      zio.aws.elasticsearch.model.PackageSource.wrap(impl.packageSource())
    override val packageDescription: Option[PackageDescription] = scala
      .Option(impl.packageDescription())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.PackageDescription(value)
      )
    override val commitMessage: Option[CommitMessage] = scala
      .Option(impl.commitMessage())
      .map(value => zio.aws.elasticsearch.model.primitives.CommitMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest
  ): zio.aws.elasticsearch.model.UpdatePackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
