package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPackagesForDomainResponse(
    domainPackageDetailsList: Option[
      Iterable[zio.aws.elasticsearch.model.DomainPackageDetails]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse = {
    import ListPackagesForDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse
      .builder()
      .optionallyWith(
        domainPackageDetailsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainPackageDetailsList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListPackagesForDomainResponse.ReadOnly =
    zio.aws.elasticsearch.model.ListPackagesForDomainResponse
      .wrap(buildAwsValue())
}
object ListPackagesForDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListPackagesForDomainResponse =
      zio.aws.elasticsearch.model.ListPackagesForDomainResponse(
        domainPackageDetailsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def domainPackageDetailsList: Option[
      List[zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly]
    ]
    def nextToken: Option[String]
    def getDomainPackageDetailsList: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainPackageDetailsList",
      domainPackageDetailsList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse
  ) extends zio.aws.elasticsearch.model.ListPackagesForDomainResponse.ReadOnly {
    override val domainPackageDetailsList: Option[
      List[zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly]
    ] = scala
      .Option(impl.domainPackageDetailsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.DomainPackageDetails.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse
  ): zio.aws.elasticsearch.model.ListPackagesForDomainResponse.ReadOnly =
    new Wrapper(impl)
}
