package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DeploymentCloseDateTimeStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ServiceSoftwareOptions(
    currentVersion: Option[String] = None,
    newVersion: Option[String] = None,
    updateAvailable: Option[Boolean] = None,
    cancellable: Option[Boolean] = None,
    updateStatus: Option[zio.aws.elasticsearch.model.DeploymentStatus] = None,
    description: Option[String] = None,
    automatedUpdateDate: Option[DeploymentCloseDateTimeStamp] = None,
    optionalDeployment: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions = {
    import ServiceSoftwareOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions
      .builder()
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(newVersion.map(value => value: java.lang.String))(
        _.newVersion
      )
      .optionallyWith(updateAvailable.map(value => value: java.lang.Boolean))(
        _.updateAvailable
      )
      .optionallyWith(cancellable.map(value => value: java.lang.Boolean))(
        _.cancellable
      )
      .optionallyWith(updateStatus.map(value => value.unwrap))(_.updateStatus)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        automatedUpdateDate.map(value =>
          DeploymentCloseDateTimeStamp.unwrap(value): Instant
        )
      )(_.automatedUpdateDate)
      .optionallyWith(
        optionalDeployment.map(value => value: java.lang.Boolean)
      )(_.optionalDeployment)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly =
    zio.aws.elasticsearch.model.ServiceSoftwareOptions.wrap(buildAwsValue())
}
object ServiceSoftwareOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ServiceSoftwareOptions =
      zio.aws.elasticsearch.model.ServiceSoftwareOptions(
        currentVersion.map(value => value),
        newVersion.map(value => value),
        updateAvailable.map(value => value),
        cancellable.map(value => value),
        updateStatus.map(value => value),
        description.map(value => value),
        automatedUpdateDate.map(value => value),
        optionalDeployment.map(value => value)
      )
    def currentVersion: Option[String]
    def newVersion: Option[String]
    def updateAvailable: Option[Boolean]
    def cancellable: Option[Boolean]
    def updateStatus: Option[zio.aws.elasticsearch.model.DeploymentStatus]
    def description: Option[String]
    def automatedUpdateDate: Option[DeploymentCloseDateTimeStamp]
    def optionalDeployment: Option[Boolean]
    def getCurrentVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getNewVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newVersion", newVersion)
    def getUpdateAvailable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("updateAvailable", updateAvailable)
    def getCancellable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cancellable", cancellable)
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.DeploymentStatus] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutomatedUpdateDate
        : ZIO[Any, AwsError, DeploymentCloseDateTimeStamp] =
      AwsError.unwrapOptionField("automatedUpdateDate", automatedUpdateDate)
    def getOptionalDeployment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("optionalDeployment", optionalDeployment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions
  ) extends zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly {
    override val currentVersion: Option[String] =
      scala.Option(impl.currentVersion()).map(value => value: String)
    override val newVersion: Option[String] =
      scala.Option(impl.newVersion()).map(value => value: String)
    override val updateAvailable: Option[Boolean] =
      scala.Option(impl.updateAvailable()).map(value => value: Boolean)
    override val cancellable: Option[Boolean] =
      scala.Option(impl.cancellable()).map(value => value: Boolean)
    override val updateStatus
        : Option[zio.aws.elasticsearch.model.DeploymentStatus] = scala
      .Option(impl.updateStatus())
      .map(value => zio.aws.elasticsearch.model.DeploymentStatus.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val automatedUpdateDate: Option[DeploymentCloseDateTimeStamp] =
      scala
        .Option(impl.automatedUpdateDate())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .DeploymentCloseDateTimeStamp(value)
        )
    override val optionalDeployment: Option[Boolean] =
      scala.Option(impl.optionalDeployment()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions
  ): zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly = new Wrapper(
    impl
  )
}
