package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.IntegerClass
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SnapshotOptions(
    automatedSnapshotStartHour: Option[IntegerClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions = {
    import SnapshotOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions
      .builder()
      .optionallyWith(
        automatedSnapshotStartHour.map(value =>
          IntegerClass.unwrap(value): Integer
        )
      )(_.automatedSnapshotStartHour)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly =
    zio.aws.elasticsearch.model.SnapshotOptions.wrap(buildAwsValue())
}
object SnapshotOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.SnapshotOptions =
      zio.aws.elasticsearch.model
        .SnapshotOptions(automatedSnapshotStartHour.map(value => value))
    def automatedSnapshotStartHour: Option[IntegerClass]
    def getAutomatedSnapshotStartHour: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField(
        "automatedSnapshotStartHour",
        automatedSnapshotStartHour
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions
  ) extends zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly {
    override val automatedSnapshotStartHour: Option[IntegerClass] = scala
      .Option(impl.automatedSnapshotStartHour())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions
  ): zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly = new Wrapper(impl)
}
