package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.CrossClusterSearchConnectionStatusMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InboundCrossClusterSearchConnectionStatus(
    statusCode: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode
    ] = None,
    message: Option[CrossClusterSearchConnectionStatusMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatus = {
    import InboundCrossClusterSearchConnectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatus
      .builder()
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(
        message.map(value =>
          CrossClusterSearchConnectionStatusMessage.unwrap(
            value
          ): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus.ReadOnly =
    zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus
      .wrap(buildAwsValue())
}
object InboundCrossClusterSearchConnectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus =
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus(
        statusCode.map(value => value),
        message.map(value => value)
      )
    def statusCode: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode
    ]
    def message: Option[CrossClusterSearchConnectionStatusMessage]
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
    def getMessage
        : ZIO[Any, AwsError, CrossClusterSearchConnectionStatusMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatus
  ) extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus.ReadOnly {
    override val statusCode: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode
    ] = scala
      .Option(impl.statusCode())
      .map(value =>
        zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatusCode
          .wrap(value)
      )
    override val message: Option[CrossClusterSearchConnectionStatusMessage] =
      scala
        .Option(impl.message())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .CrossClusterSearchConnectionStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnectionStatus
  ): zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus.ReadOnly =
    new Wrapper(impl)
}
