package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.InstanceRole
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeElasticsearchInstanceTypeLimitsResponse(
    limitsByRole: Option[
      Map[InstanceRole, zio.aws.elasticsearch.model.Limits]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse = {
    import DescribeElasticsearchInstanceTypeLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse
      .builder()
      .optionallyWith(
        limitsByRole.map(value =>
          value
            .map({ case (key, value) =>
              (InstanceRole.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.limitsByRole)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse
      .wrap(buildAwsValue())
}
object DescribeElasticsearchInstanceTypeLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse =
      zio.aws.elasticsearch.model
        .DescribeElasticsearchInstanceTypeLimitsResponse(
          limitsByRole.map(value =>
            value.map({ case (key, value) =>
              key -> value.asEditable
            })
          )
        )
    def limitsByRole
        : Option[Map[InstanceRole, zio.aws.elasticsearch.model.Limits.ReadOnly]]
    def getLimitsByRole: ZIO[Any, AwsError, Map[
      InstanceRole,
      zio.aws.elasticsearch.model.Limits.ReadOnly
    ]] = AwsError.unwrapOptionField("limitsByRole", limitsByRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse
  ) extends zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse.ReadOnly {
    override val limitsByRole: Option[
      Map[InstanceRole, zio.aws.elasticsearch.model.Limits.ReadOnly]
    ] = scala
      .Option(impl.limitsByRole())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elasticsearch.model.primitives.InstanceRole(
              key
            ) -> zio.aws.elasticsearch.model.Limits.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse
  ): zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
