package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.ARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveTagsRequest(arn: ARN, tagKeys: Iterable[String]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest = {
    import RemoveTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest
      .builder()
      .arn(ARN.unwrap(arn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.RemoveTagsRequest.ReadOnly =
    zio.aws.elasticsearch.model.RemoveTagsRequest.wrap(buildAwsValue())
}
object RemoveTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.RemoveTagsRequest =
      zio.aws.elasticsearch.model.RemoveTagsRequest(arn, tagKeys)
    def arn: ARN
    def tagKeys: List[String]
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest
  ) extends zio.aws.elasticsearch.model.RemoveTagsRequest.ReadOnly {
    override val arn: ARN =
      zio.aws.elasticsearch.model.primitives.ARN(impl.arn())
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest
  ): zio.aws.elasticsearch.model.RemoveTagsRequest.ReadOnly = new Wrapper(impl)
}
