package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DissociatePackageResponse(
    domainPackageDetails: Option[
      zio.aws.elasticsearch.model.DomainPackageDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DissociatePackageResponse = {
    import DissociatePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DissociatePackageResponse
      .builder()
      .optionallyWith(domainPackageDetails.map(value => value.buildAwsValue()))(
        _.domainPackageDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DissociatePackageResponse.ReadOnly =
    zio.aws.elasticsearch.model.DissociatePackageResponse.wrap(buildAwsValue())
}
object DissociatePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DissociatePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DissociatePackageResponse =
      zio.aws.elasticsearch.model.DissociatePackageResponse(
        domainPackageDetails.map(value => value.asEditable)
      )
    def domainPackageDetails
        : Option[zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly]
    def getDomainPackageDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("domainPackageDetails", domainPackageDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DissociatePackageResponse
  ) extends zio.aws.elasticsearch.model.DissociatePackageResponse.ReadOnly {
    override val domainPackageDetails
        : Option[zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly] =
      scala
        .Option(impl.domainPackageDetails())
        .map(value =>
          zio.aws.elasticsearch.model.DomainPackageDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DissociatePackageResponse
  ): zio.aws.elasticsearch.model.DissociatePackageResponse.ReadOnly =
    new Wrapper(impl)
}
