package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoTuneOptionsInput(
    desiredState: Option[zio.aws.elasticsearch.model.AutoTuneDesiredState] =
      None,
    maintenanceSchedules: Option[
      Iterable[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput = {
    import AutoTuneOptionsInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput
      .builder()
      .optionallyWith(desiredState.map(value => value.unwrap))(_.desiredState)
      .optionallyWith(
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.maintenanceSchedules)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneOptionsInput.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneOptionsInput.wrap(buildAwsValue())
}
object AutoTuneOptionsInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneOptionsInput =
      zio.aws.elasticsearch.model.AutoTuneOptionsInput(
        desiredState.map(value => value),
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def desiredState: Option[zio.aws.elasticsearch.model.AutoTuneDesiredState]
    def maintenanceSchedules: Option[
      List[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ]
    def getDesiredState
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.AutoTuneDesiredState] =
      AwsError.unwrapOptionField("desiredState", desiredState)
    def getMaintenanceSchedules: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly
    ]] =
      AwsError.unwrapOptionField("maintenanceSchedules", maintenanceSchedules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput
  ) extends zio.aws.elasticsearch.model.AutoTuneOptionsInput.ReadOnly {
    override val desiredState
        : Option[zio.aws.elasticsearch.model.AutoTuneDesiredState] = scala
      .Option(impl.desiredState())
      .map(value =>
        zio.aws.elasticsearch.model.AutoTuneDesiredState.wrap(value)
      )
    override val maintenanceSchedules: Option[
      List[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ] = scala
      .Option(impl.maintenanceSchedules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput
  ): zio.aws.elasticsearch.model.AutoTuneOptionsInput.ReadOnly = new Wrapper(
    impl
  )
}
