package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{StartTimestamp, UpgradeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UpgradeHistory(
    upgradeName: Option[UpgradeName] = None,
    startTimestamp: Option[StartTimestamp] = None,
    upgradeStatus: Option[zio.aws.elasticsearch.model.UpgradeStatus] = None,
    stepsList: Option[Iterable[zio.aws.elasticsearch.model.UpgradeStepItem]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpgradeHistory = {
    import UpgradeHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpgradeHistory
      .builder()
      .optionallyWith(
        upgradeName.map(value => UpgradeName.unwrap(value): java.lang.String)
      )(_.upgradeName)
      .optionallyWith(
        startTimestamp.map(value => StartTimestamp.unwrap(value): Instant)
      )(_.startTimestamp)
      .optionallyWith(upgradeStatus.map(value => value.unwrap))(_.upgradeStatus)
      .optionallyWith(
        stepsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stepsList)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly =
    zio.aws.elasticsearch.model.UpgradeHistory.wrap(buildAwsValue())
}
object UpgradeHistory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpgradeHistory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.UpgradeHistory =
      zio.aws.elasticsearch.model.UpgradeHistory(
        upgradeName.map(value => value),
        startTimestamp.map(value => value),
        upgradeStatus.map(value => value),
        stepsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def upgradeName: Option[UpgradeName]
    def startTimestamp: Option[StartTimestamp]
    def upgradeStatus: Option[zio.aws.elasticsearch.model.UpgradeStatus]
    def stepsList
        : Option[List[zio.aws.elasticsearch.model.UpgradeStepItem.ReadOnly]]
    def getUpgradeName: ZIO[Any, AwsError, UpgradeName] =
      AwsError.unwrapOptionField("upgradeName", upgradeName)
    def getStartTimestamp: ZIO[Any, AwsError, StartTimestamp] =
      AwsError.unwrapOptionField("startTimestamp", startTimestamp)
    def getUpgradeStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.UpgradeStatus] =
      AwsError.unwrapOptionField("upgradeStatus", upgradeStatus)
    def getStepsList: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.UpgradeStepItem.ReadOnly
    ]] = AwsError.unwrapOptionField("stepsList", stepsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeHistory
  ) extends zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly {
    override val upgradeName: Option[UpgradeName] = scala
      .Option(impl.upgradeName())
      .map(value => zio.aws.elasticsearch.model.primitives.UpgradeName(value))
    override val startTimestamp: Option[StartTimestamp] = scala
      .Option(impl.startTimestamp())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.StartTimestamp(value)
      )
    override val upgradeStatus
        : Option[zio.aws.elasticsearch.model.UpgradeStatus] = scala
      .Option(impl.upgradeStatus())
      .map(value => zio.aws.elasticsearch.model.UpgradeStatus.wrap(value))
    override val stepsList
        : Option[List[zio.aws.elasticsearch.model.UpgradeStepItem.ReadOnly]] =
      scala
        .Option(impl.stepsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.UpgradeStepItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeHistory
  ): zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly = new Wrapper(impl)
}
