package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AdvancedSecurityOptionsStatus(
    options: zio.aws.elasticsearch.model.AdvancedSecurityOptions,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsStatus = {
    import AdvancedSecurityOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus
      .wrap(buildAwsValue())
}
object AdvancedSecurityOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus =
      zio.aws.elasticsearch.model
        .AdvancedSecurityOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsStatus
  ) extends zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.ReadOnly {
    override val options
        : zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly =
      zio.aws.elasticsearch.model.AdvancedSecurityOptions.wrap(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsStatus
  ): zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
