package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{
  SubnetId,
  LoadBalancerArn
}
import scala.jdk.CollectionConverters.*
final case class SetSubnetsRequest(
    loadBalancerArn: LoadBalancerArn,
    subnets: Optional[Iterable[SubnetId]] = Optional.Absent,
    subnetMappings: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.SubnetMapping]
    ] = Optional.Absent,
    ipAddressType: Optional[
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest = {
    import SetSubnetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest
      .builder()
      .loadBalancerArn(
        LoadBalancerArn.unwrap(loadBalancerArn): java.lang.String
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        subnetMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetMappings)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.SetSubnetsRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SetSubnetsRequest.wrap(buildAwsValue())
}
object SetSubnetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.SetSubnetsRequest =
      zio.aws.elasticloadbalancingv2.model.SetSubnetsRequest(
        loadBalancerArn,
        subnets.map(value => value),
        subnetMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipAddressType.map(value => value)
      )
    def loadBalancerArn: LoadBalancerArn
    def subnets: Optional[List[SubnetId]]
    def subnetMappings: Optional[
      List[zio.aws.elasticloadbalancingv2.model.SubnetMapping.ReadOnly]
    ]
    def ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType]
    def getLoadBalancerArn: ZIO[Any, Nothing, LoadBalancerArn] =
      ZIO.succeed(loadBalancerArn)
    def getSubnets: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSubnetMappings: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.SubnetMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("subnetMappings", subnetMappings)
    def getIpAddressType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest
  ) extends zio.aws.elasticloadbalancingv2.model.SetSubnetsRequest.ReadOnly {
    override val loadBalancerArn: LoadBalancerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .LoadBalancerArn(impl.loadBalancerArn())
    override val subnets: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.SubnetId(item)
        }.toList
      )
    override val subnetMappings: Optional[
      List[zio.aws.elasticloadbalancingv2.model.SubnetMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.SubnetMapping.wrap(item)
        }.toList
      )
    override val ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.IpAddressType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest
  ): zio.aws.elasticloadbalancingv2.model.SetSubnetsRequest.ReadOnly =
    new Wrapper(impl)
}
