package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{IsDefault, RuleArn}
import scala.jdk.CollectionConverters.*
final case class Rule(
    ruleArn: Optional[RuleArn] = Optional.Absent,
    priority: Optional[String] = Optional.Absent,
    conditions: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.RuleCondition]
    ] = Optional.Absent,
    actions: Optional[Iterable[zio.aws.elasticloadbalancingv2.model.Action]] =
      Optional.Absent,
    isDefault: Optional[IsDefault] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule
      .builder()
      .optionallyWith(
        ruleArn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .optionallyWith(priority.map(value => value: java.lang.String))(
        _.priority
      )
      .optionallyWith(
        conditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conditions)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(
        isDefault.map(value => IsDefault.unwrap(value): java.lang.Boolean)
      )(_.isDefault)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Rule =
      zio.aws.elasticloadbalancingv2.model.Rule(
        ruleArn.map(value => value),
        priority.map(value => value),
        conditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isDefault.map(value => value)
      )
    def ruleArn: Optional[RuleArn]
    def priority: Optional[String]
    def conditions: Optional[
      List[zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly]
    ]
    def actions
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]]
    def isDefault: Optional[IsDefault]
    def getRuleArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
    def getPriority: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("priority", priority)
    def getConditions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("conditions", conditions)
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Action.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
    def getIsDefault: ZIO[Any, AwsError, IsDefault] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule
  ) extends zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly {
    override val ruleArn: Optional[RuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.RuleArn(value)
      )
    override val priority: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: String)
    override val conditions: Optional[
      List[zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conditions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.RuleCondition.wrap(item)
        }.toList
      )
    override val actions
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Action.wrap(item)
          }.toList
        )
    override val isDefault: Optional[IsDefault] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.IsDefault(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule
  ): zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly = new Wrapper(impl)
}
