package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  TargetGroupWeight,
  TargetGroupArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TargetGroupTuple(
    targetGroupArn: Optional[TargetGroupArn] = Optional.Absent,
    weight: Optional[TargetGroupWeight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple = {
    import TargetGroupTuple.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple
      .builder()
      .optionallyWith(
        targetGroupArn.map(value =>
          TargetGroupArn.unwrap(value): java.lang.String
        )
      )(_.targetGroupArn)
      .optionallyWith(
        weight.map(value => TargetGroupWeight.unwrap(value): Integer)
      )(_.weight)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.wrap(buildAwsValue())
}
object TargetGroupTuple {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.TargetGroupTuple =
      zio.aws.elasticloadbalancingv2.model.TargetGroupTuple(
        targetGroupArn.map(value => value),
        weight.map(value => value)
      )
    def targetGroupArn: Optional[TargetGroupArn]
    def weight: Optional[TargetGroupWeight]
    def getTargetGroupArn: ZIO[Any, AwsError, TargetGroupArn] =
      AwsError.unwrapOptionField("targetGroupArn", targetGroupArn)
    def getWeight: ZIO[Any, AwsError, TargetGroupWeight] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple
  ) extends zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.ReadOnly {
    override val targetGroupArn: Optional[TargetGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetGroupArn())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn(value)
        )
    override val weight: Optional[TargetGroupWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.weight())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupWeight(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple
  ): zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.ReadOnly =
    new Wrapper(impl)
}
