package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  PageSize,
  Marker,
  LoadBalancerName,
  LoadBalancerArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeLoadBalancersRequest(
    loadBalancerArns: Optional[Iterable[LoadBalancerArn]] = Optional.Absent,
    names: Optional[Iterable[LoadBalancerName]] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest = {
    import DescribeLoadBalancersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
      .builder()
      .optionallyWith(
        loadBalancerArns.map(value =>
          value.map { item =>
            LoadBalancerArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.loadBalancerArns)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            LoadBalancerName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
      .wrap(buildAwsValue())
}
object DescribeLoadBalancersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest(
        loadBalancerArns.map(value => value),
        names.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def loadBalancerArns: Optional[List[LoadBalancerArn]]
    def names: Optional[List[LoadBalancerName]]
    def marker: Optional[Marker]
    def pageSize: Optional[PageSize]
    def getLoadBalancerArns: ZIO[Any, AwsError, List[LoadBalancerArn]] =
      AwsError.unwrapOptionField("loadBalancerArns", loadBalancerArns)
    def getNames: ZIO[Any, AwsError, List[LoadBalancerName]] =
      AwsError.unwrapOptionField("names", names)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.ReadOnly {
    override val loadBalancerArns: Optional[List[LoadBalancerArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives
              .LoadBalancerArn(item)
          }.toList
        )
    override val names: Optional[List[LoadBalancerName]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerName(item)
        }.toList
      )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.ReadOnly =
    new Wrapper(impl)
}
