package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn
import scala.jdk.CollectionConverters.*
final case class SetIpAddressTypeRequest(
    loadBalancerArn: LoadBalancerArn,
    ipAddressType: zio.aws.elasticloadbalancingv2.model.IpAddressType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest = {
    import SetIpAddressTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest
      .builder()
      .loadBalancerArn(
        LoadBalancerArn.unwrap(loadBalancerArn): java.lang.String
      )
      .ipAddressType(ipAddressType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeRequest
      .wrap(buildAwsValue())
}
object SetIpAddressTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeRequest =
      zio.aws.elasticloadbalancingv2.model
        .SetIpAddressTypeRequest(loadBalancerArn, ipAddressType)
    def loadBalancerArn: LoadBalancerArn
    def ipAddressType: zio.aws.elasticloadbalancingv2.model.IpAddressType
    def getLoadBalancerArn: ZIO[Any, Nothing, LoadBalancerArn] =
      ZIO.succeed(loadBalancerArn)
    def getIpAddressType: ZIO[
      Any,
      Nothing,
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = ZIO.succeed(ipAddressType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest
  ) extends zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeRequest.ReadOnly {
    override val loadBalancerArn: LoadBalancerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .LoadBalancerArn(impl.loadBalancerArn())
    override val ipAddressType
        : zio.aws.elasticloadbalancingv2.model.IpAddressType =
      zio.aws.elasticloadbalancingv2.model.IpAddressType
        .wrap(impl.ipAddressType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest
  ): zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeRequest.ReadOnly =
    new Wrapper(impl)
}
