package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters.*
sealed trait TargetHealthReasonEnum {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum
}
object TargetHealthReasonEnum {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum
  ): zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum = value match {
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.ELB_REGISTRATION_IN_PROGRESS =>
      val r = `Elb.RegistrationInProgress`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.ELB_INITIAL_HEALTH_CHECKING =>
      val r = `Elb.InitialHealthChecking`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_RESPONSE_CODE_MISMATCH =>
      val r = `Target.ResponseCodeMismatch`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_TIMEOUT =>
      val r = `Target.Timeout`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_FAILED_HEALTH_CHECKS =>
      val r = `Target.FailedHealthChecks`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_NOT_REGISTERED =>
      val r = `Target.NotRegistered`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_NOT_IN_USE =>
      val r = `Target.NotInUse`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_DEREGISTRATION_IN_PROGRESS =>
      val r = `Target.DeregistrationInProgress`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_INVALID_STATE =>
      val r = `Target.InvalidState`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_IP_UNUSABLE =>
      val r = `Target.IpUnusable`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_HEALTH_CHECK_DISABLED =>
      val r = `Target.HealthCheckDisabled`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.ELB_INTERNAL_ERROR =>
      val r = `Elb.InternalError`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object `Elb.RegistrationInProgress`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.ELB_REGISTRATION_IN_PROGRESS
  }
  case object `Elb.InitialHealthChecking`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.ELB_INITIAL_HEALTH_CHECKING
  }
  case object `Target.ResponseCodeMismatch`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_RESPONSE_CODE_MISMATCH
  }
  case object `Target.Timeout`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_TIMEOUT
  }
  case object `Target.FailedHealthChecks`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_FAILED_HEALTH_CHECKS
  }
  case object `Target.NotRegistered`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_NOT_REGISTERED
  }
  case object `Target.NotInUse`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_NOT_IN_USE
  }
  case object `Target.DeregistrationInProgress`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_DEREGISTRATION_IN_PROGRESS
  }
  case object `Target.InvalidState`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_INVALID_STATE
  }
  case object `Target.IpUnusable`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_IP_UNUSABLE
  }
  case object `Target.HealthCheckDisabled`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.TARGET_HEALTH_CHECK_DISABLED
  }
  case object `Elb.InternalError`
      extends zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum.ELB_INTERNAL_ERROR
  }
}
