package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters.*
sealed trait LoadBalancerTypeEnum {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum
}
object LoadBalancerTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum
  ): zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum = value match {
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum.APPLICATION =>
      val r = application
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum.NETWORK =>
      val r = network
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum.GATEWAY =>
      val r = gateway
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object application
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum.APPLICATION
  }
  case object network
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum.NETWORK
  }
  case object gateway
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum.GATEWAY
  }
}
