package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  PageSize,
  Marker,
  RuleArn,
  ListenerArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeRulesRequest(
    listenerArn: Optional[ListenerArn] = Optional.Absent,
    ruleArns: Optional[Iterable[RuleArn]] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest = {
    import DescribeRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest
      .builder()
      .optionallyWith(
        listenerArn.map(value => ListenerArn.unwrap(value): java.lang.String)
      )(_.listenerArn)
      .optionallyWith(
        ruleArns.map(value =>
          value.map { item =>
            RuleArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ruleArns)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest
      .wrap(buildAwsValue())
}
object DescribeRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest(
        listenerArn.map(value => value),
        ruleArns.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def listenerArn: Optional[ListenerArn]
    def ruleArns: Optional[List[RuleArn]]
    def marker: Optional[Marker]
    def pageSize: Optional[PageSize]
    def getListenerArn: ZIO[Any, AwsError, ListenerArn] =
      AwsError.unwrapOptionField("listenerArn", listenerArn)
    def getRuleArns: ZIO[Any, AwsError, List[RuleArn]] =
      AwsError.unwrapOptionField("ruleArns", ruleArns)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest.ReadOnly {
    override val listenerArn: Optional[ListenerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.listenerArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.ListenerArn(value)
      )
    override val ruleArns: Optional[List[RuleArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.RuleArn(item)
        }.toList
      )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest.ReadOnly =
    new Wrapper(impl)
}
