package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SetSubnetsResponse(
    availabilityZones: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.AvailabilityZone]
    ] = Optional.Absent,
    ipAddressType: Optional[
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse = {
    import SetSubnetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse
      .wrap(buildAwsValue())
}
object SetSubnetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse =
      zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse(
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipAddressType.map(value => value)
      )
    def availabilityZones: Optional[
      List[zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly]
    ]
    def ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType]
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getIpAddressType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse
  ) extends zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse.ReadOnly {
    override val availabilityZones: Optional[
      List[zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.AvailabilityZone.wrap(item)
        }.toList
      )
    override val ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.IpAddressType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse
  ): zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse.ReadOnly =
    new Wrapper(impl)
}
