package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.{
  SecurityGroupId,
  LoadBalancerArn
}
import scala.jdk.CollectionConverters.*
final case class SetSecurityGroupsRequest(
    loadBalancerArn: LoadBalancerArn,
    securityGroups: Iterable[SecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest = {
    import SetSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest
      .builder()
      .loadBalancerArn(
        LoadBalancerArn.unwrap(loadBalancerArn): java.lang.String
      )
      .securityGroups(securityGroups.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsRequest
      .wrap(buildAwsValue())
}
object SetSecurityGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsRequest =
      zio.aws.elasticloadbalancingv2.model
        .SetSecurityGroupsRequest(loadBalancerArn, securityGroups)
    def loadBalancerArn: LoadBalancerArn
    def securityGroups: List[SecurityGroupId]
    def getLoadBalancerArn: ZIO[Any, Nothing, LoadBalancerArn] =
      ZIO.succeed(loadBalancerArn)
    def getSecurityGroups: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest
  ) extends zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsRequest.ReadOnly {
    override val loadBalancerArn: LoadBalancerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .LoadBalancerArn(impl.loadBalancerArn())
    override val securityGroups: List[SecurityGroupId] = impl
      .securityGroups()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.primitives.SecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest
  ): zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
