package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  PageSize,
  Marker,
  SslPolicyName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeSslPoliciesRequest(
    names: Optional[Iterable[SslPolicyName]] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent,
    loadBalancerType: Optional[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest = {
    import DescribeSslPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            SslPolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(loadBalancerType.map(value => value.unwrap))(
        _.loadBalancerType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
      .wrap(buildAwsValue())
}
object DescribeSslPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest(
        names.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value),
        loadBalancerType.map(value => value)
      )
    def names: Optional[List[SslPolicyName]]
    def marker: Optional[Marker]
    def pageSize: Optional[PageSize]
    def loadBalancerType
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum]
    def getNames: ZIO[Any, AwsError, List[SslPolicyName]] =
      AwsError.unwrapOptionField("names", names)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getLoadBalancerType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum
    ] = AwsError.unwrapOptionField("loadBalancerType", loadBalancerType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest.ReadOnly {
    override val names: Optional[List[SslPolicyName]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.SslPolicyName(item)
        }.toList
      )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
    override val loadBalancerType
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerType())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
